/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Point;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class CameraUpdateFactory {
    private static ICameraUpdateFactoryDelegate zziqx;

    private CameraUpdateFactory() {
    }

    private static ICameraUpdateFactoryDelegate zzawa() {
        return (ICameraUpdateFactoryDelegate)zzbq.checkNotNull((Object)zziqx, (Object)"CameraUpdateFactory is not initialized");
    }

    public static void zza(ICameraUpdateFactoryDelegate iCameraUpdateFactoryDelegate) {
        zziqx = (ICameraUpdateFactoryDelegate)zzbq.checkNotNull((Object)iCameraUpdateFactoryDelegate);
    }

    public static CameraUpdate zoomIn() {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().zoomIn());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomOut() {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().zoomOut());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate scrollBy(float f, float f2) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().scrollBy(f, f2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomTo(float f) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().zoomTo(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomBy(float f) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().zoomBy(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate zoomBy(float f, Point point) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().zoomByWithFocus(f, point.x, point.y));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().newCameraPosition(cameraPosition));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().newLatLng(latLng));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, float f) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().newLatLngZoom(latLng, f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().newLatLngBounds(latLngBounds, n));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n, int n2, int n3) {
        try {
            return new CameraUpdate(CameraUpdateFactory.zzawa().newLatLngBoundsWithSize(latLngBounds, n, n2, n3));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

