/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzaa;

public final class GoogleMapOptions
extends zzbfm
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzaa();
    private Boolean zzisb;
    private Boolean zzisc;
    private int zzisd = -1;
    private CameraPosition zzise;
    private Boolean zzisf;
    private Boolean zzisg;
    private Boolean zzish;
    private Boolean zzisi;
    private Boolean zzisj;
    private Boolean zzisk;
    private Boolean zzisl;
    private Boolean zzism;
    private Boolean zzisn;
    private Float zziso = null;
    private Float zzisp = null;
    private LatLngBounds zzisq = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzisb = zza.zza(by);
        this.zzisc = zza.zza(by2);
        this.zzisd = n;
        this.zzise = cameraPosition;
        this.zzisf = zza.zza(by3);
        this.zzisg = zza.zza(by4);
        this.zzish = zza.zza(by5);
        this.zzisi = zza.zza(by6);
        this.zzisj = zza.zza(by7);
        this.zzisk = zza.zza(by8);
        this.zzisl = zza.zza(by9);
        this.zzism = zza.zza(by10);
        this.zzisn = zza.zza(by11);
        this.zziso = f;
        this.zzisp = f2;
        this.zzisq = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (byte)zza.zzb(googleMapOptions.zzisb));
        zzbfp.zza((Parcel)parcel2, (int)3, (byte)zza.zzb(googleMapOptions.zzisc));
        zzbfp.zzc((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (byte)zza.zzb(googleMapOptions.zzisf));
        zzbfp.zza((Parcel)parcel2, (int)7, (byte)zza.zzb(googleMapOptions.zzisg));
        zzbfp.zza((Parcel)parcel2, (int)8, (byte)zza.zzb(googleMapOptions.zzish));
        zzbfp.zza((Parcel)parcel2, (int)9, (byte)zza.zzb(googleMapOptions.zzisi));
        zzbfp.zza((Parcel)parcel2, (int)10, (byte)zza.zzb(googleMapOptions.zzisj));
        zzbfp.zza((Parcel)parcel2, (int)11, (byte)zza.zzb(googleMapOptions.zzisk));
        zzbfp.zza((Parcel)parcel2, (int)12, (byte)zza.zzb(googleMapOptions.zzisl));
        zzbfp.zza((Parcel)parcel2, (int)14, (byte)zza.zzb(googleMapOptions.zzism));
        zzbfp.zza((Parcel)parcel2, (int)15, (byte)zza.zzb(googleMapOptions.zzisn));
        zzbfp.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzisb = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzisc = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzisd = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzise = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzisf = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzisg = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzish = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzisi = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzisj = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzisk = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzisl = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzism = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzisn = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zziso = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzisp = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzisq = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzisb;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzisc;
    }

    public final int getMapType() {
        return this.zzisd;
    }

    public final CameraPosition getCamera() {
        return this.zzise;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzisf;
    }

    public final Boolean getCompassEnabled() {
        return this.zzisg;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzish;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzisi;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzisj;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzisk;
    }

    public final Boolean getLiteMode() {
        return this.zzisl;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzism;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzisn;
    }

    public final Float getMinZoomPreference() {
        return this.zziso;
    }

    public final Float getMaxZoomPreference() {
        return this.zzisp;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzisq;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbg.zzx((Object)((Object)this)).zzg("MapType", (Object)this.zzisd).zzg("LiteMode", (Object)this.zzisl).zzg("Camera", (Object)this.zzise).zzg("CompassEnabled", (Object)this.zzisg).zzg("ZoomControlsEnabled", (Object)this.zzisf).zzg("ScrollGesturesEnabled", (Object)this.zzish).zzg("ZoomGesturesEnabled", (Object)this.zzisi).zzg("TiltGesturesEnabled", (Object)this.zzisj).zzg("RotateGesturesEnabled", (Object)this.zzisk).zzg("MapToolbarEnabled", (Object)this.zzism).zzg("AmbientEnabled", (Object)this.zzisn).zzg("MinZoomPreference", (Object)this.zziso).zzg("MaxZoomPreference", (Object)this.zzisp).zzg("LatLngBoundsForCameraTarget", (Object)this.zzisq).zzg("ZOrderOnTop", (Object)this.zzisb).zzg("UseViewLifecycleInFragment", (Object)this.zzisc).toString();
    }
}

