/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.internal.zzg;

public final class GroundOverlay {
    private final zzg zziuq;

    public GroundOverlay(zzg zzg2) {
        this.zziuq = (zzg)zzbq.checkNotNull((Object)zzg2);
    }

    public final void remove() {
        try {
            this.zziuq.remove();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getId() {
        try {
            return this.zziuq.getId();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPosition(LatLng latLng) {
        try {
            this.zziuq.setPosition(latLng);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final LatLng getPosition() {
        try {
            return this.zziuq.getPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setImage(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbq.checkNotNull((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        try {
            IObjectWrapper iObjectWrapper = bitmapDescriptor.zzavz();
            this.zziuq.zzac(iObjectWrapper);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setDimensions(float f) {
        try {
            this.zziuq.setDimensions(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setDimensions(float f, float f2) {
        try {
            this.zziuq.zzf(f, f2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getWidth() {
        try {
            return this.zziuq.getWidth();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getHeight() {
        try {
            return this.zziuq.getHeight();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPositionFromBounds(LatLngBounds latLngBounds) {
        try {
            this.zziuq.setPositionFromBounds(latLngBounds);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final LatLngBounds getBounds() {
        try {
            return this.zziuq.getBounds();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setBearing(float f) {
        try {
            this.zziuq.setBearing(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getBearing() {
        try {
            return this.zziuq.getBearing();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setZIndex(float f) {
        try {
            this.zziuq.setZIndex(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getZIndex() {
        try {
            return this.zziuq.getZIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setVisible(boolean bl) {
        try {
            this.zziuq.setVisible(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isVisible() {
        try {
            return this.zziuq.isVisible();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setClickable(boolean bl) {
        try {
            this.zziuq.setClickable(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isClickable() {
        try {
            return this.zziuq.isClickable();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTransparency(float f) {
        try {
            this.zziuq.setTransparency(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getTransparency() {
        try {
            return this.zziuq.getTransparency();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTag(Object object) {
        try {
            this.zziuq.setTag(zzn.zzz((Object)object));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Object getTag() {
        try {
            return zzn.zzx((IObjectWrapper)this.zziuq.getTag());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof GroundOverlay)) {
            return false;
        }
        try {
            return this.zziuq.zzb(((GroundOverlay)object).zziuq);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int hashCode() {
        try {
            return this.zziuq.hashCodeRemote();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

