/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzac;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzjbp;

    public MapView(Context context) {
        super(context);
        this.zzjbp = new zzb((ViewGroup)this, context, null);
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzjbp = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzjbp = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzjbp = new zzb((ViewGroup)this, context, googleMapOptions);
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zzjbp.onCreate(bundle);
            if (this.zzjbp.zzarg() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zzjbp.onResume();
    }

    public final void onPause() {
        this.zzjbp.onPause();
    }

    public final void onStart() {
        this.zzjbp.onStart();
    }

    public final void onStop() {
        this.zzjbp.onStop();
    }

    public final void onDestroy() {
        this.zzjbp.onDestroy();
    }

    public final void onLowMemory() {
        this.zzjbp.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzjbp.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbq.zzgn((String)"getMapAsync() must be called on the main thread");
        this.zzjbp.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbq.zzgn((String)"onEnterAmbient() must be called on the main thread");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzjbp;
        if (zzb2.zzarg() != null) {
            ((zza)zzb2.zzarg()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbq.zzgn((String)"onExitAmbient() must be called on the main thread");
        zzb zzb2 = this.zzjbp;
        if (zzb2.zzarg() != null) {
            ((zza)zzb2.zzarg()).onExitAmbient();
        }
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzjbs;
        private final Context zzjbt;
        private zzo<zza> zzjbn;
        private final GoogleMapOptions zzjbu;
        private final List<OnMapReadyCallback> zzjbo = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzjbs = viewGroup;
            this.zzjbt = context;
            this.zzjbu = googleMapOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzjbn = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzjbn != null && zzb2.zzarg() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzjbt);
                    IMapViewDelegate iMapViewDelegate = zzbz.zzdz(zzb2.zzjbt).zza(zzn.zzz((Object)zzb2.zzjbt), zzb2.zzjbu);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    zzb2.zzjbn.zza((LifecycleDelegate)new zza(zzb2.zzjbs, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : zzb2.zzjbo) {
                        ((zza)zzb2.zzarg()).getMapAsync(onMapReadyCallback);
                    }
                    zzb2.zzjbo.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzarg() != null) {
                ((zza)this.zzarg()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzjbo.add(onMapReadyCallback);
        }
    }

    @Hide
    static final class zza
    implements MapLifecycleDelegate {
        private final ViewGroup parent;
        private final IMapViewDelegate zzjbq;
        private View zzjbr;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzjbq = (IMapViewDelegate)zzbq.checkNotNull((Object)iMapViewDelegate);
            this.parent = (ViewGroup)zzbq.checkNotNull((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzjbq.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                this.zzjbr = (View)zzn.zzy((IObjectWrapper)this.zzjbq.getView());
                this.parent.removeAllViews();
                this.parent.addView(this.zzjbr);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public final void onStart() {
            try {
                this.zzjbq.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzjbq.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzjbq.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzjbq.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzjbq.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzjbq.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzjbq.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzjbq.getMapAsync(new zzac(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzjbq.onEnterAmbient(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzjbq.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

