/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzjdf;
    private LatLng zzjdg;
    private float width;
    private float height;
    private LatLngBounds zzjdh;
    private float bearing;
    private float zzjda;
    private boolean zzjdb = true;
    private float zzjdi = 0.0f;
    private float zzjdj = 0.5f;
    private float zzjdk = 0.5f;
    private boolean zzjdc = false;

    @Hide
    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzjdf = new BitmapDescriptor(IObjectWrapper.zza.zzaq((IBinder)iBinder));
        this.zzjdg = latLng;
        this.width = f;
        this.height = f2;
        this.zzjdh = latLngBounds;
        this.bearing = f3;
        this.zzjda = f4;
        this.zzjdb = bl;
        this.zzjdi = f5;
        this.zzjdj = f6;
        this.zzjdk = f7;
        this.zzjdc = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zzjdf.zzaxq().asBinder(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        zzbgo.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        zzbgo.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        zzbgo.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        zzbgo.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        zzbgo.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        zzbgo.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        zzbgo.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbq.checkNotNull((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzjdf = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zzjdj = f;
        this.zzjdk = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbq.zza((this.zzjdh == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbq.zza((this.zzjdh == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbq.checkArgument((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbq.checkArgument((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbq.checkArgument((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzjdg = latLng;
        this.width = f;
        this.height = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzjdg);
        zzbq.zza((this.zzjdg == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzjdh = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.bearing = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzjda = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zzjdb = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbq.checkArgument((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzjdi = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zzjdc = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zzjdf;
    }

    public final LatLng getLocation() {
        return this.zzjdg;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final LatLngBounds getBounds() {
        return this.zzjdh;
    }

    public final float getBearing() {
        return this.bearing;
    }

    public final float getZIndex() {
        return this.zzjda;
    }

    public final float getTransparency() {
        return this.zzjdi;
    }

    public final float getAnchorU() {
        return this.zzjdj;
    }

    public final float getAnchorV() {
        return this.zzjdk;
    }

    public final boolean isVisible() {
        return this.zzjdb;
    }

    public final boolean isClickable() {
        return this.zzjdc;
    }
}

