/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import javax.annotation.concurrent.GuardedBy;

public final class MapsInitializer {
    @GuardedBy(value="MapsInitializer.class")
    private static boolean zzbl = false;

    public static synchronized int initialize(Context context) {
        zze zze2;
        Preconditions.checkNotNull((Object)context, (Object)"Context is null");
        if (zzbl) {
            return 0;
        }
        try {
            zze2 = zzbz.zza(context);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            return googlePlayServicesNotAvailableException.errorCode;
        }
        zze zze3 = zze2;
        try {
            CameraUpdateFactory.zza(zze3.zzd());
            BitmapDescriptorFactory.zza(zze3.zze());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        zzbl = true;
        return 0;
    }

    private MapsInitializer() {
    }
}

