/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.StreetViewPanoramaCamera;
import com.google.android.gms.maps.model.StreetViewSource;
import com.google.android.gms.maps.zzai;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaOptionsCreator")
public final class StreetViewPanoramaOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<StreetViewPanoramaOptions> CREATOR = new zzai();
    @SafeParcelable.Field(id=2, getter="getStreetViewPanoramaCamera")
    private StreetViewPanoramaCamera zzbw;
    @SafeParcelable.Field(id=3, getter="getPanoramaId")
    private String panoId;
    @SafeParcelable.Field(id=4, getter="getPosition")
    private LatLng position;
    @SafeParcelable.Field(id=5, getter="getRadius")
    private Integer zzbx;
    @SafeParcelable.Field(id=6, getter="getUserNavigationEnabledForParcel", type="byte")
    private Boolean zzby = true;
    @SafeParcelable.Field(id=7, getter="getZoomGesturesEnabledForParcel", type="byte")
    private Boolean zzap = true;
    @SafeParcelable.Field(id=8, getter="getPanningGesturesEnabledForParcel", type="byte")
    private Boolean zzbz = true;
    @SafeParcelable.Field(id=9, getter="getStreetNamesEnabledForParcel", type="byte")
    private Boolean zzca = true;
    @SafeParcelable.Field(id=10, getter="getUseViewLifecycleInFragmentForParcel", type="byte")
    private Boolean zzak;
    @SafeParcelable.Field(id=11, getter="getSource")
    private StreetViewSource zzcb = StreetViewSource.DEFAULT;

    @SafeParcelable.Constructor
    StreetViewPanoramaOptions(@SafeParcelable.Param(id=2) StreetViewPanoramaCamera streetViewPanoramaCamera, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) LatLng latLng, @SafeParcelable.Param(id=5) Integer n, @SafeParcelable.Param(id=6) byte by, @SafeParcelable.Param(id=7) byte by2, @SafeParcelable.Param(id=8) byte by3, @SafeParcelable.Param(id=9) byte by4, @SafeParcelable.Param(id=10) byte by5, @SafeParcelable.Param(id=11) StreetViewSource streetViewSource) {
        this.zzbw = streetViewPanoramaCamera;
        this.position = latLng;
        this.zzbx = n;
        this.panoId = string;
        this.zzby = zza.zza(by);
        this.zzap = zza.zza(by2);
        this.zzbz = zza.zza(by3);
        this.zzca = zza.zza(by4);
        this.zzak = zza.zza(by5);
        this.zzcb = streetViewSource;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        StreetViewPanoramaOptions streetViewPanoramaOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)streetViewPanoramaOptions.getStreetViewPanoramaCamera(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)streetViewPanoramaOptions.getPanoramaId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)streetViewPanoramaOptions.getPosition(), (int)n, (boolean)false);
        SafeParcelWriter.writeIntegerObject((Parcel)parcel2, (int)5, (Integer)streetViewPanoramaOptions.getRadius(), (boolean)false);
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)6, (byte)zza.zza(streetViewPanoramaOptions.zzby));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)7, (byte)zza.zza(streetViewPanoramaOptions.zzap));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)8, (byte)zza.zza(streetViewPanoramaOptions.zzbz));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)9, (byte)zza.zza(streetViewPanoramaOptions.zzca));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)10, (byte)zza.zza(streetViewPanoramaOptions.zzak));
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)11, (Parcelable)streetViewPanoramaOptions.getSource(), (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public StreetViewPanoramaOptions() {
    }

    public final StreetViewPanoramaOptions panoramaCamera(StreetViewPanoramaCamera streetViewPanoramaCamera) {
        this.zzbw = streetViewPanoramaCamera;
        return this;
    }

    public final StreetViewPanoramaOptions panoramaId(String string) {
        this.panoId = string;
        return this;
    }

    public final StreetViewPanoramaOptions position(LatLng latLng) {
        this.position = latLng;
        return this;
    }

    public final StreetViewPanoramaOptions position(LatLng latLng, Integer n) {
        this.position = latLng;
        this.zzbx = n;
        return this;
    }

    public final StreetViewPanoramaOptions position(LatLng latLng, Integer n, StreetViewSource streetViewSource) {
        this.position = latLng;
        this.zzbx = n;
        this.zzcb = streetViewSource;
        return this;
    }

    public final StreetViewPanoramaOptions position(LatLng latLng, StreetViewSource streetViewSource) {
        this.position = latLng;
        this.zzcb = streetViewSource;
        return this;
    }

    public final StreetViewPanoramaOptions userNavigationEnabled(boolean bl) {
        this.zzby = bl;
        return this;
    }

    public final StreetViewPanoramaOptions zoomGesturesEnabled(boolean bl) {
        this.zzap = bl;
        return this;
    }

    public final StreetViewPanoramaOptions panningGesturesEnabled(boolean bl) {
        this.zzbz = bl;
        return this;
    }

    public final StreetViewPanoramaOptions streetNamesEnabled(boolean bl) {
        this.zzca = bl;
        return this;
    }

    public final StreetViewPanoramaOptions useViewLifecycleInFragment(boolean bl) {
        this.zzak = bl;
        return this;
    }

    public final StreetViewPanoramaCamera getStreetViewPanoramaCamera() {
        return this.zzbw;
    }

    public final LatLng getPosition() {
        return this.position;
    }

    public final Integer getRadius() {
        return this.zzbx;
    }

    public final StreetViewSource getSource() {
        return this.zzcb;
    }

    public final String getPanoramaId() {
        return this.panoId;
    }

    public final Boolean getUserNavigationEnabled() {
        return this.zzby;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzap;
    }

    public final Boolean getPanningGesturesEnabled() {
        return this.zzbz;
    }

    public final Boolean getStreetNamesEnabled() {
        return this.zzca;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzak;
    }

    public final String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("PanoramaId", (Object)this.panoId).add("Position", (Object)this.position).add("Radius", (Object)this.zzbx).add("Source", (Object)this.zzcb).add("StreetViewPanoramaCamera", (Object)this.zzbw).add("UserNavigationEnabled", (Object)this.zzby).add("ZoomGesturesEnabled", (Object)this.zzap).add("PanningGesturesEnabled", (Object)this.zzbz).add("StreetNamesEnabled", (Object)this.zzca).add("UseViewLifecycleInFragment", (Object)this.zzak).toString();
    }
}

