/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PolygonOptionsCreator")
public final class PolygonOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    @SafeParcelable.Field(id=2, getter="getPoints")
    private final List<LatLng> zzdw;
    @SafeParcelable.Field(id=3, getter="getHolesForParcel", type="java.util.List")
    private final List<List<LatLng>> zzdx;
    @SafeParcelable.Field(id=4, getter="getStrokeWidth")
    private float zzcq = 10.0f;
    @SafeParcelable.Field(id=5, getter="getStrokeColor")
    private int strokeColor = -16777216;
    @SafeParcelable.Field(id=6, getter="getFillColor")
    private int fillColor = 0;
    @SafeParcelable.Field(id=7, getter="getZIndex")
    private float zzcr = 0.0f;
    @SafeParcelable.Field(id=8, getter="isVisible")
    private boolean zzcs = true;
    @SafeParcelable.Field(id=9, getter="isGeodesic")
    private boolean zzdy = false;
    @SafeParcelable.Field(id=10, getter="isClickable")
    private boolean zzct = false;
    @SafeParcelable.Field(id=11, getter="getStrokeJointType")
    private int zzdz = 0;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getStrokePattern")
    private List<PatternItem> zzcu = null;

    public PolygonOptions() {
        this.zzdw = new ArrayList<LatLng>();
        this.zzdx = new ArrayList<List<LatLng>>();
    }

    @SafeParcelable.Constructor
    PolygonOptions(@SafeParcelable.Param(id=2) List<LatLng> list, @SafeParcelable.Param(id=3) List list2, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) int n, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f2, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) int n3, @SafeParcelable.Param(id=12) @Nullable List<PatternItem> list3) {
        this.zzdw = list;
        this.zzdx = list2;
        this.zzcq = f;
        this.strokeColor = n;
        this.fillColor = n2;
        this.zzcr = f2;
        this.zzcs = bl;
        this.zzdy = bl2;
        this.zzct = bl3;
        this.zzdz = n3;
        this.zzcu = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        SafeParcelWriter.writeList((Parcel)parcel2, (int)3, polygonOptions.zzdx, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzdw.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzdw.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzdw.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzdx.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.zzcq = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.strokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zzdz = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zzcu = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.fillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zzcr = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zzcs = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzdy = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zzct = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzdw;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzdx;
    }

    public final float getStrokeWidth() {
        return this.zzcq;
    }

    public final int getStrokeColor() {
        return this.strokeColor;
    }

    public final int getStrokeJointType() {
        return this.zzdz;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zzcu;
    }

    public final int getFillColor() {
        return this.fillColor;
    }

    public final float getZIndex() {
        return this.zzcr;
    }

    public final boolean isVisible() {
        return this.zzcs;
    }

    public final boolean isGeodesic() {
        return this.zzdy;
    }

    public final boolean isClickable() {
        return this.zzct;
    }
}

