/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.DeferredLifecycleHelper;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnStreetViewPanoramaReadyCallback;
import com.google.android.gms.maps.StreetViewPanoramaOptions;
import com.google.android.gms.maps.internal.IStreetViewPanoramaFragmentDelegate;
import com.google.android.gms.maps.internal.StreetViewLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzah;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class StreetViewPanoramaFragment
extends Fragment {
    private final zzb zzbt = new zzb(this);

    public static StreetViewPanoramaFragment newInstance() {
        return new StreetViewPanoramaFragment();
    }

    public static StreetViewPanoramaFragment newInstance(StreetViewPanoramaOptions streetViewPanoramaOptions) {
        StreetViewPanoramaFragment streetViewPanoramaFragment = new StreetViewPanoramaFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("StreetViewPanoramaOptions", (Parcelable)streetViewPanoramaOptions);
        streetViewPanoramaFragment.setArguments(bundle);
        return streetViewPanoramaFragment;
    }

    public StreetViewPanoramaFragment() {
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzbt.setActivity(activity);
    }

    @SuppressLint(value={"NewApi"})
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            super.onInflate(activity, attributeSet, bundle);
            this.zzbt.setActivity(activity);
            Bundle bundle2 = new Bundle();
            this.zzbt.onInflate(activity, bundle2, bundle);
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbt.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbt.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbt.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbt.onResume();
    }

    public void onPause() {
        this.zzbt.onPause();
        super.onPause();
    }

    public void onStop() {
        this.zzbt.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.zzbt.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzbt.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzbt.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(StreetViewPanoramaFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(StreetViewPanoramaFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zzbt.onSaveInstanceState(bundle);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    public void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
        Preconditions.checkMainThread((String)"getStreetViewPanoramaAsync() must be called on the main thread");
        this.zzbt.getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
    }

    @VisibleForTesting
    static final class zzb
    extends DeferredLifecycleHelper<zza> {
        private final Fragment zzba;
        private OnDelegateCreatedListener<zza> zzbd;
        private Activity zzbe;
        private final List<OnStreetViewPanoramaReadyCallback> zzbw = new ArrayList<OnStreetViewPanoramaReadyCallback>();

        @VisibleForTesting
        zzb(Fragment fragment) {
            this.zzba = fragment;
        }

        protected final void createDelegate(OnDelegateCreatedListener<zza> onDelegateCreatedListener) {
            this.zzbd = onDelegateCreatedListener;
            this.zzd();
        }

        private final void zzd() {
            if (this.zzbe != null && this.zzbd != null && this.getDelegate() == null) {
                try {
                    MapsInitializer.initialize((Context)this.zzbe);
                    IStreetViewPanoramaFragmentDelegate iStreetViewPanoramaFragmentDelegate = zzbz.zza((Context)this.zzbe).zzd(ObjectWrapper.wrap((Object)this.zzbe));
                    this.zzbd.onDelegateCreated((LifecycleDelegate)new zza(this.zzba, iStreetViewPanoramaFragmentDelegate));
                    for (OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback : this.zzbw) {
                        ((zza)this.getDelegate()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                    }
                    this.zzbw.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        private final void setActivity(Activity activity) {
            this.zzbe = activity;
            this.zzd();
        }

        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            if (this.getDelegate() != null) {
                ((zza)this.getDelegate()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                return;
            }
            this.zzbw.add(onStreetViewPanoramaReadyCallback);
        }
    }

    @VisibleForTesting
    static final class zza
    implements StreetViewLifecycleDelegate {
        private final Fragment zzba;
        private final IStreetViewPanoramaFragmentDelegate zzbu;

        public zza(Fragment fragment, IStreetViewPanoramaFragmentDelegate iStreetViewPanoramaFragmentDelegate) {
            this.zzbu = (IStreetViewPanoramaFragmentDelegate)Preconditions.checkNotNull((Object)iStreetViewPanoramaFragmentDelegate);
            this.zzba = (Fragment)Preconditions.checkNotNull((Object)fragment);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            try {
                Bundle bundle3 = new Bundle();
                zzby.zza(bundle2, bundle3);
                this.zzbu.onInflate(ObjectWrapper.wrap((Object)activity), null, bundle3);
                zzby.zza(bundle3, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                Bundle bundle3 = this.zzba.getArguments();
                if (bundle3 != null && bundle3.containsKey("StreetViewPanoramaOptions")) {
                    zzby.zza(bundle2, "StreetViewPanoramaOptions", bundle3.getParcelable("StreetViewPanoramaOptions"));
                }
                this.zzbu.onCreate(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            IObjectWrapper iObjectWrapper;
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                iObjectWrapper = this.zzbu.onCreateView(ObjectWrapper.wrap((Object)layoutInflater), ObjectWrapper.wrap((Object)viewGroup), bundle2);
                zzby.zza(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        }

        public final void onStart() {
            try {
                this.zzbu.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbu.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbu.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbu.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            try {
                this.zzbu.onDestroyView();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroy() {
            try {
                this.zzbu.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzbu.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzbu.onSaveInstanceState(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            try {
                this.zzbu.getStreetViewPanoramaAsync(new zzah(this, onStreetViewPanoramaReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

