/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.CustomCap;
import com.google.android.gms.maps.model.RoundCap;
import com.google.android.gms.maps.model.SquareCap;
import com.google.android.gms.maps.model.zzb;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CapCreator")
public class Cap
extends AbstractSafeParcelable {
    private static final String TAG = Cap.class.getSimpleName();
    public static final Parcelable.Creator<Cap> CREATOR = new zzb();
    @SafeParcelable.Field(id=2, getter="getType")
    private final int type;
    @SafeParcelable.Field(id=3, getter="getWrappedBitmapDescriptorImplBinder", type="android.os.IBinder")
    @Nullable
    private final BitmapDescriptor bitmapDescriptor;
    @SafeParcelable.Field(id=4, getter="getBitmapRefWidth")
    @Nullable
    private final Float zzcn;

    private Cap(int n, @Nullable BitmapDescriptor bitmapDescriptor, @Nullable Float f) {
        boolean bl = f != null && f.floatValue() > 0.0f;
        Preconditions.checkArgument((n != 3 || bitmapDescriptor != null && bl ? 1 : 0) != 0, (Object)String.format("Invalid Cap: type=%s bitmapDescriptor=%s bitmapRefWidth=%s", n, bitmapDescriptor, f));
        this.type = n;
        this.bitmapDescriptor = bitmapDescriptor;
        this.zzcn = f;
    }

    @SafeParcelable.Constructor
    Cap(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) @Nullable IBinder iBinder, @SafeParcelable.Param(id=4) @Nullable Float f) {
        BitmapDescriptor bitmapDescriptor;
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            bitmapDescriptor = null;
        } else {
            IObjectWrapper iObjectWrapper = IObjectWrapper.Stub.asInterface((IBinder)iBinder2);
            bitmapDescriptor = new BitmapDescriptor(iObjectWrapper);
        }
        this(n, bitmapDescriptor, f);
    }

    protected Cap(@NonNull BitmapDescriptor bitmapDescriptor, float f) {
        this(3, bitmapDescriptor, Float.valueOf(f));
    }

    protected Cap(int n) {
        this(n, (BitmapDescriptor)null, (Float)null);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Cap cap = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)cap.type);
        Cap cap2 = cap;
        SafeParcelWriter.writeIBinder((Parcel)parcel2, (int)3, cap2.bitmapDescriptor == null ? null : cap2.bitmapDescriptor.zzb().asBinder(), (boolean)false);
        SafeParcelWriter.writeFloatObject((Parcel)parcel2, (int)4, (Float)cap.zzcn, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.bitmapDescriptor, this.zzcn});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cap)) {
            return false;
        }
        Cap cap = (Cap)((Object)object);
        return this.type == cap.type && Objects.equal((Object)this.bitmapDescriptor, (Object)cap.bitmapDescriptor) && Objects.equal((Object)this.zzcn, (Object)cap.zzcn);
    }

    public String toString() {
        int n = this.type;
        return new StringBuilder(23).append("[Cap: type=").append(n).append("]").toString();
    }

    final Cap zzh() {
        switch (this.type) {
            case 0: {
                return new ButtCap();
            }
            case 1: {
                return new SquareCap();
            }
            case 2: {
                return new RoundCap();
            }
            case 3: {
                return new CustomCap(this.bitmapDescriptor, this.zzcn.floatValue());
            }
        }
        int n = this.type;
        Log.w((String)TAG, (String)new StringBuilder(29).append("Unknown Cap type: ").append(n).toString());
        return this;
    }
}

