/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.StrokeStyle;
import com.google.android.gms.maps.model.StyleSpan;
import com.google.android.gms.maps.model.zzm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PolylineOptionsCreator")
public final class PolylineOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PolylineOptions> CREATOR;
    @SafeParcelable.Field(id=2, getter="getPoints")
    private final List zza;
    @SafeParcelable.Field(id=3, getter="getWidth")
    private float zzb = 10.0f;
    @SafeParcelable.Field(id=4, getter="getColor")
    private int zzc = -16777216;
    @SafeParcelable.Field(id=5, getter="getZIndex")
    private float zzd = 0.0f;
    @SafeParcelable.Field(id=6, getter="isVisible")
    private boolean zze = true;
    @SafeParcelable.Field(id=7, getter="isGeodesic")
    private boolean zzf = false;
    @SafeParcelable.Field(id=8, getter="isClickable")
    private boolean zzg = false;
    @SafeParcelable.Field(id=9, getter="getStartCap")
    private Cap zzh;
    @SafeParcelable.Field(id=10, getter="getEndCap")
    private Cap zzi;
    @SafeParcelable.Field(id=11, getter="getJointType")
    private int zzj;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getPattern")
    private List zzk;
    @SafeParcelable.Field(id=13, getter="getSpans")
    private List zzl;

    public float getWidth() {
        return this.zzb;
    }

    public float getZIndex() {
        return this.zzd;
    }

    public int getColor() {
        return this.zzc;
    }

    public int getJointType() {
        return this.zzj;
    }

    @NonNull
    public Cap getEndCap() {
        return this.zzi.zza();
    }

    @NonNull
    public Cap getStartCap() {
        return this.zzh.zza();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions add(@NonNull LatLng point) {
        void var1_1;
        Preconditions.checkNotNull((Object)this.zza, (Object)"point must not be null.");
        this.zza.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions add(LatLng ... points) {
        void var1_1;
        Preconditions.checkNotNull((Object)points, (Object)"points must not be null.");
        Collections.addAll(this.zza, var1_1);
        return this;
    }

    @NonNull
    public PolylineOptions addAll(@NonNull Iterable<LatLng> points) {
        Iterator iterator;
        Preconditions.checkNotNull(points, (Object)"points must not be null.");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (LatLng)((Object)object);
            this.zza.add(object);
        }
        return this;
    }

    @NonNull
    public PolylineOptions addAllSpans(@NonNull Iterable<StyleSpan> spans) {
        Iterator<StyleSpan> iterator = spans.iterator();
        while (iterator.hasNext()) {
            this.addSpan(iterator.next());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions addSpan(@NonNull StyleSpan span) {
        void var1_1;
        this.zzl.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions addSpan(StyleSpan ... spans) {
        int n = spans.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            this.addSpan((StyleSpan)var1_1[i]);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions clickable(boolean clickable) {
        void var1_1;
        this.zzg = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions color(int color) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions endCap(@NonNull Cap endCap) {
        void var1_1;
        this.zzi = (Cap)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"endCap must not be null"));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions geodesic(boolean geodesic) {
        void var1_1;
        this.zzf = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions jointType(int jointType) {
        void var1_1;
        this.zzj = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions pattern(@Nullable List<PatternItem> pattern) {
        void var1_1;
        this.zzk = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions startCap(@NonNull Cap startCap) {
        void var1_1;
        this.zzh = (Cap)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"startCap must not be null"));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions visible(boolean visible) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions width(float width) {
        void var1_1;
        this.zzb = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PolylineOptions zIndex(float zIndex) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    @Nullable
    public List<PatternItem> getPattern() {
        return this.zzk;
    }

    @NonNull
    public List<LatLng> getPoints() {
        return this.zza;
    }

    static {
        zzm zzm2;
        CREATOR = zzm2 = new zzm();
    }

    public PolylineOptions() {
        Object object = new ButtCap();
        this.zzh = object;
        object = new ButtCap();
        this.zzi = object;
        this.zzj = 0;
        this.zzk = null;
        this.zzl = object;
        super();
        this.zza = object;
    }

    @SafeParcelable.Constructor
    PolylineOptions(@SafeParcelable.Param(id=2) List list, @SafeParcelable.Param(id=3) float f, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) float f2, @SafeParcelable.Param(id=6) boolean bl, @SafeParcelable.Param(id=7) boolean bl2, @SafeParcelable.Param(id=8) boolean bl3, @SafeParcelable.Param(id=9) @Nullable Cap cap, @SafeParcelable.Param(id=10) @Nullable Cap cap2, @SafeParcelable.Param(id=11) int n2, @SafeParcelable.Param(id=12) @Nullable List list2, @SafeParcelable.Param(id=13) @Nullable List list3) {
        Object object = new ButtCap();
        this.zzh = object;
        object = new ButtCap();
        this.zzi = object;
        this.zzj = 0;
        this.zzk = null;
        this.zzl = object;
        this.zza = list;
        this.zzb = f;
        this.zzc = n;
        this.zzd = f2;
        this.zze = bl;
        this.zzf = bl2;
        this.zzg = bl3;
        if (cap != null) {
            this.zzh = cap;
        }
        if (cap2 != null) {
            this.zzi = cap2;
        }
        this.zzj = n2;
        this.zzk = list2;
        if (list3 != null) {
            this.zzl = list3;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)2, this.getPoints(), (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.getWidth());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getColor());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)5, (float)this.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)6, (boolean)this.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)7, (boolean)this.isGeodesic());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.isClickable());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)9, (Parcelable)this.getStartCap(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)10, (Parcelable)this.getEndCap(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)11, (int)this.getJointType());
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)12, this.getPattern(), (boolean)false);
        ArrayList<StyleSpan> arrayList = new ArrayList<StyleSpan>(this.zzl.size());
        for (StyleSpan styleSpan : this.zzl) {
            StrokeStyle.Builder builder = new StrokeStyle.Builder(styleSpan.getStyle());
            builder.zzd(this.zzb);
            builder.zzc(this.zze);
            StyleSpan styleSpan2 = new StyleSpan(builder.build(), styleSpan.getSegments());
            arrayList.add(styleSpan2);
        }
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)13, arrayList, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean isClickable() {
        return this.zzg;
    }

    public boolean isGeodesic() {
        return this.zzf;
    }

    public boolean isVisible() {
        return this.zze;
    }
}

