/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.R;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzac;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GoogleMapOptionsCreator")
public final class GoogleMapOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzac();
    private static final Integer zza = Color.argb((int)255, (int)236, (int)233, (int)225);
    @SafeParcelable.Field(id=2, getter="getZOrderOnTopForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzb;
    @SafeParcelable.Field(id=3, getter="getUseViewLifecycleInFragmentForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzc;
    @SafeParcelable.Field(id=4, getter="getMapType")
    private int zzd = -1;
    @SafeParcelable.Field(id=5, getter="getCamera")
    @Nullable
    private CameraPosition zze;
    @SafeParcelable.Field(id=6, getter="getZoomControlsEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzf;
    @SafeParcelable.Field(id=7, getter="getCompassEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzg;
    @SafeParcelable.Field(id=8, getter="getScrollGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzh;
    @SafeParcelable.Field(id=9, getter="getZoomGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzi;
    @SafeParcelable.Field(id=10, getter="getTiltGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzj;
    @SafeParcelable.Field(id=11, getter="getRotateGesturesEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzk;
    @SafeParcelable.Field(id=12, getter="getLiteModeForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzl;
    @SafeParcelable.Field(id=14, getter="getMapToolbarEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzm;
    @SafeParcelable.Field(id=15, getter="getAmbientEnabledForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzn;
    @SafeParcelable.Field(id=16, getter="getMinZoomPreference")
    @Nullable
    private Float zzo = null;
    @SafeParcelable.Field(id=17, getter="getMaxZoomPreference")
    @Nullable
    private Float zzp = null;
    @SafeParcelable.Field(id=18, getter="getLatLngBoundsForCameraTarget")
    @Nullable
    private LatLngBounds zzq = null;
    @SafeParcelable.Field(id=19, getter="getScrollGesturesEnabledDuringRotateOrZoomForParcel", type="byte", defaultValue="-1")
    @Nullable
    private Boolean zzr;
    @SafeParcelable.Field(id=20, getter="getBackgroundColor")
    @Nullable
    @ColorInt
    private Integer zzs = null;
    @SafeParcelable.Field(id=21, getter="getMapId")
    @Nullable
    private String zzt = null;

    public int getMapType() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions ambientEnabled(boolean enabled) {
        void var1_1;
        this.zzn = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions backgroundColor(@Nullable @ColorInt Integer backgroundColor) {
        void var1_1;
        this.zzs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions camera(@Nullable CameraPosition camera) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions compassEnabled(boolean enabled) {
        void var1_1;
        this.zzg = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static GoogleMapOptions createFromAttributes(@Nullable Context context, @Nullable AttributeSet attrs) {
        String string;
        Context context2;
        void var1_1;
        if (context == null || var1_1 == null) {
            return null;
        }
        TypedArray typedArray = context2.getResources().obtainAttributes((AttributeSet)var1_1, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGesturesDuringRotateOrZoom)) {
            googleMapOptions.scrollGesturesEnabledDuringRotateOrZoom(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGesturesDuringRotateOrZoom, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_backgroundColor)) {
            googleMapOptions.backgroundColor(typedArray.getColor(R.styleable.MapAttrs_backgroundColor, zza.intValue()));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_mapId) && (string = typedArray.getString(R.styleable.MapAttrs_mapId)) != null && !string.isEmpty()) {
            googleMapOptions.mapId(string);
        }
        googleMapOptions.latLngBoundsForCameraTarget(GoogleMapOptions.zzb(context2, (AttributeSet)var1_1));
        googleMapOptions.camera(GoogleMapOptions.zza(context2, (AttributeSet)var1_1));
        typedArray.recycle();
        return googleMapOptions;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions latLngBoundsForCameraTarget(@Nullable LatLngBounds llbounds) {
        void var1_1;
        this.zzq = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions liteMode(boolean enabled) {
        void var1_1;
        this.zzl = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions mapId(@NonNull String mapId) {
        void var1_1;
        this.zzt = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        void var1_1;
        this.zzm = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions mapType(int mapType) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions maxZoomPreference(float maxZoomPreference) {
        void var1_1;
        this.zzp = Float.valueOf((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions minZoomPreference(float minZoomPreference) {
        void var1_1;
        this.zzo = Float.valueOf((float)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzk = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzh = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions scrollGesturesEnabledDuringRotateOrZoom(boolean enabled) {
        void var1_1;
        this.zzr = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzj = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        void var1_1;
        this.zzc = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        void var1_1;
        this.zzb = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        void var1_1;
        this.zzf = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        void var1_1;
        this.zzi = (boolean)var1_1;
        return this;
    }

    @Nullable
    public CameraPosition getCamera() {
        return this.zze;
    }

    @Nullable
    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzq;
    }

    @Nullable
    public Boolean getAmbientEnabled() {
        return this.zzn;
    }

    @Nullable
    public Boolean getCompassEnabled() {
        return this.zzg;
    }

    @Nullable
    public Boolean getLiteMode() {
        return this.zzl;
    }

    @Nullable
    public Boolean getMapToolbarEnabled() {
        return this.zzm;
    }

    @Nullable
    public Boolean getRotateGesturesEnabled() {
        return this.zzk;
    }

    @Nullable
    public Boolean getScrollGesturesEnabled() {
        return this.zzh;
    }

    @Nullable
    public Boolean getScrollGesturesEnabledDuringRotateOrZoom() {
        return this.zzr;
    }

    @Nullable
    public Boolean getTiltGesturesEnabled() {
        return this.zzj;
    }

    @Nullable
    public Boolean getUseViewLifecycleInFragment() {
        return this.zzc;
    }

    @Nullable
    public Boolean getZOrderOnTop() {
        return this.zzb;
    }

    @Nullable
    public Boolean getZoomControlsEnabled() {
        return this.zzf;
    }

    @Nullable
    public Boolean getZoomGesturesEnabled() {
        return this.zzi;
    }

    @Nullable
    public Float getMaxZoomPreference() {
        return this.zzp;
    }

    @Nullable
    public Float getMinZoomPreference() {
        return this.zzo;
    }

    @Nullable
    @ColorInt
    public Integer getBackgroundColor() {
        return this.zzs;
    }

    @Nullable
    public String getMapId() {
        return this.zzt;
    }

    @NonNull
    public String toString() {
        Integer n = this.zzd;
        return Objects.toStringHelper((Object)((Object)this)).add("MapType", (Object)n).add("LiteMode", (Object)this.zzl).add("Camera", (Object)this.zze).add("CompassEnabled", (Object)this.zzg).add("ZoomControlsEnabled", (Object)this.zzf).add("ScrollGesturesEnabled", (Object)this.zzh).add("ZoomGesturesEnabled", (Object)this.zzi).add("TiltGesturesEnabled", (Object)this.zzj).add("RotateGesturesEnabled", (Object)this.zzk).add("ScrollGesturesEnabledDuringRotateOrZoom", (Object)this.zzr).add("MapToolbarEnabled", (Object)this.zzm).add("AmbientEnabled", (Object)this.zzn).add("MinZoomPreference", (Object)this.zzo).add("MaxZoomPreference", (Object)this.zzp).add("BackgroundColor", (Object)this.zzs).add("LatLngBoundsForCameraTarget", (Object)this.zzq).add("ZOrderOnTop", (Object)this.zzb).add("UseViewLifecycleInFragment", (Object)this.zzc).toString();
    }

    public GoogleMapOptions() {
    }

    @SafeParcelable.Constructor
    GoogleMapOptions(@SafeParcelable.Param(id=2) byte by, @SafeParcelable.Param(id=3) byte by2, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) @Nullable CameraPosition cameraPosition, @SafeParcelable.Param(id=6) byte by3, @SafeParcelable.Param(id=7) byte by4, @SafeParcelable.Param(id=8) byte by5, @SafeParcelable.Param(id=9) byte by6, @SafeParcelable.Param(id=10) byte by7, @SafeParcelable.Param(id=11) byte by8, @SafeParcelable.Param(id=12) byte by9, @SafeParcelable.Param(id=14) byte by10, @SafeParcelable.Param(id=15) byte by11, @SafeParcelable.Param(id=16) @Nullable Float f, @SafeParcelable.Param(id=17) @Nullable Float f2, @SafeParcelable.Param(id=18) @Nullable LatLngBounds latLngBounds, @SafeParcelable.Param(id=19) byte by12, @SafeParcelable.Param(id=20) @Nullable @ColorInt Integer n2, @SafeParcelable.Param(id=21) @Nullable String string) {
        this.zzb = com.google.android.gms.maps.internal.zza.zzb(by);
        this.zzc = com.google.android.gms.maps.internal.zza.zzb(by2);
        this.zzd = n;
        this.zze = cameraPosition;
        this.zzf = com.google.android.gms.maps.internal.zza.zzb(by3);
        this.zzg = com.google.android.gms.maps.internal.zza.zzb(by4);
        this.zzh = com.google.android.gms.maps.internal.zza.zzb(by5);
        this.zzi = com.google.android.gms.maps.internal.zza.zzb(by6);
        this.zzj = com.google.android.gms.maps.internal.zza.zzb(by7);
        this.zzk = com.google.android.gms.maps.internal.zza.zzb(by8);
        this.zzl = com.google.android.gms.maps.internal.zza.zzb(by9);
        this.zzm = com.google.android.gms.maps.internal.zza.zzb(by10);
        this.zzn = com.google.android.gms.maps.internal.zza.zzb(by11);
        this.zzo = f;
        this.zzp = f2;
        this.zzq = latLngBounds;
        this.zzr = com.google.android.gms.maps.internal.zza.zzb(by12);
        this.zzs = n2;
        this.zzt = string;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)2, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzb));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)3, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzc));
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getMapType());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getCamera(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)6, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzf));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)7, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzg));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)8, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzh));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)9, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzi));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)10, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzj));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)11, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzk));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)12, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzl));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)14, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzm));
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)15, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzn));
        SafeParcelWriter.writeFloatObject((Parcel)var1_1, (int)16, (Float)this.getMinZoomPreference(), (boolean)false);
        SafeParcelWriter.writeFloatObject((Parcel)var1_1, (int)17, (Float)this.getMaxZoomPreference(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)18, (Parcelable)this.getLatLngBoundsForCameraTarget(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)19, (byte)com.google.android.gms.maps.internal.zza.zza(this.zzr));
        SafeParcelWriter.writeIntegerObject((Parcel)var1_1, (int)20, (Integer)this.getBackgroundColor(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)21, (String)this.getMapId(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static CameraPosition zza(@Nullable Context context, @Nullable AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        float f = typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLat) ? typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLat, 0.0f) : 0.0f;
        float f2 = typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLng) ? typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLng, 0.0f) : 0.0f;
        double d = f;
        double d2 = f2;
        LatLng latLng = new LatLng(d, d2);
        CameraPosition.Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraZoom)) {
            builder.zoom(typedArray.getFloat(R.styleable.MapAttrs_cameraZoom, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraBearing)) {
            builder.bearing(typedArray.getFloat(R.styleable.MapAttrs_cameraBearing, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTilt)) {
            builder.tilt(typedArray.getFloat(R.styleable.MapAttrs_cameraTilt, 0.0f));
        }
        typedArray.recycle();
        return builder.build();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static LatLngBounds zzb(@Nullable Context object, @Nullable AttributeSet object2) {
        void var0_2;
        Float f;
        if (object == null || f == null) {
            return null;
        }
        TypedArray typedArray = object.getResources().obtainAttributes((AttributeSet)f, R.styleable.MapAttrs);
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude)) {
            Float f2 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude, 0.0f));
        } else {
            Object var0_4 = null;
        }
        f = typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude) ? Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude, 0.0f)) : null;
        Float f3 = typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude) ? Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude, 0.0f)) : null;
        Float f4 = typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude) ? Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude, 0.0f)) : null;
        typedArray.recycle();
        if (var0_2 != null && f != null && f3 != null && f4 != null) {
            LatLng latLng = new LatLng(var0_2.floatValue(), f.floatValue());
            LatLng latLng2 = new LatLng(f3.floatValue(), f4.floatValue());
            return new LatLngBounds(latLng, latLng2);
        }
        return null;
    }
}

