/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.zzav;
import com.google.android.gms.maps.zzaw;

public class SupportMapFragment
extends Fragment {
    private final zzaw zza = new zzaw(this);

    /*
     * WARNING - void declaration
     */
    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        void var3_3;
        void var2_2;
        void var1_1;
        View view = this.zza.onCreateView((LayoutInflater)var1_1, (ViewGroup)var2_2, (Bundle)var3_3);
        view.setClickable(true);
        return view;
    }

    @NonNull
    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    @NonNull
    public static SupportMapFragment newInstance(@Nullable GoogleMapOptions options) {
        GoogleMapOptions googleMapOptions;
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    /*
     * WARNING - void declaration
     */
    public void getMapAsync(@NonNull OnMapReadyCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"getMapAsync must be called on the main thread.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"callback must not be null.");
        this.zza.zzb((OnMapReadyCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        void var1_1;
        ClassLoader classLoader = SupportMapFragment.class.getClassLoader();
        if (var1_1 != null && classLoader != null) {
            var1_1.setClassLoader(classLoader);
        }
        super.onActivityCreated((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onAttach(@NonNull Activity activity) {
        void var1_1;
        super.onAttach((Activity)var1_1);
        zzaw.zza(this.zza, (Activity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            void var1_1;
            super.onCreate((Bundle)var1_1);
            this.zza.onCreate((Bundle)var1_1);
        }
        catch (Throwable throwable) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            throw throwable;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
    }

    public void onDestroy() {
        this.zza.onDestroy();
        super.onDestroy();
    }

    public void onDestroyView() {
        this.zza.onDestroyView();
        super.onDestroyView();
    }

    /*
     * WARNING - void declaration
     */
    public final void onEnterAmbient(@Nullable Bundle ambientDetails) {
        Preconditions.checkMainThread((String)"onEnterAmbient must be called on the main thread.");
        Object object = object.zza;
        if (object.getDelegate() != null) {
            void var1_1;
            ((zzav)object.getDelegate()).zza((Bundle)var1_1);
            return;
        }
    }

    public final void onExitAmbient() {
        Preconditions.checkMainThread((String)"onExitAmbient must be called on the main thread.");
        Object object = object.zza;
        if (object.getDelegate() != null) {
            ((zzav)object.getDelegate()).zzb();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onInflate(@NonNull Activity activity, @NonNull AttributeSet attrs, @Nullable Bundle savedInstanceState) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            void var3_3;
            GoogleMapOptions googleMapOptions;
            void var1_1;
            super.onInflate((Activity)var1_1, (AttributeSet)googleMapOptions, (Bundle)var3_3);
            zzaw.zza(this.zza, (Activity)var1_1);
            googleMapOptions = GoogleMapOptions.createFromAttributes((Context)var1_1, (AttributeSet)googleMapOptions);
            Bundle bundle = new Bundle();
            bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
            this.zza.onInflate((Activity)var1_1, bundle, (Bundle)var3_3);
        }
        catch (Throwable throwable) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            throw throwable;
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
    }

    public void onLowMemory() {
        this.zza.onLowMemory();
        super.onLowMemory();
    }

    public void onPause() {
        this.zza.onPause();
        super.onPause();
    }

    public void onResume() {
        super.onResume();
        this.zza.onResume();
    }

    /*
     * WARNING - void declaration
     */
    public void onSaveInstanceState(@NonNull Bundle outState) {
        void var1_1;
        ClassLoader classLoader = SupportMapFragment.class.getClassLoader();
        if (var1_1 != null && classLoader != null) {
            var1_1.setClassLoader(classLoader);
        }
        super.onSaveInstanceState((Bundle)var1_1);
        this.zza.onSaveInstanceState((Bundle)var1_1);
    }

    public void onStart() {
        super.onStart();
        this.zza.onStart();
    }

    public void onStop() {
        this.zza.onStop();
        super.onStop();
    }

    /*
     * WARNING - void declaration
     */
    public void setArguments(@Nullable Bundle args) {
        void var1_1;
        super.setArguments((Bundle)var1_1);
    }
}

