/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzx;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaOrientationCreator")
public class StreetViewPanoramaOrientation
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<StreetViewPanoramaOrientation> CREATOR = new zzx();
    @SafeParcelable.Field(id=2)
    public final float tilt;
    @SafeParcelable.Field(id=3)
    public final float bearing;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull StreetViewPanoramaOrientation orientation) {
        StreetViewPanoramaOrientation streetViewPanoramaOrientation;
        return new Builder(streetViewPanoramaOrientation);
    }

    @NonNull
    public String toString() {
        float f = this.tilt;
        float f2 = this.bearing;
        return Objects.toStringHelper((Object)((Object)this)).add("tilt", (Object)Float.valueOf(f)).add("bearing", (Object)Float.valueOf(f2)).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public StreetViewPanoramaOrientation(@SafeParcelable.Param(id=2) float tilt, @SafeParcelable.Param(id=3) float bearing) {
        void var2_2;
        void var1_1;
        boolean bl = !(var1_1 < -90.0f) ? var1_1 <= 90.0f : false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tilt needs to be between -90 and 90 inclusive: ");
        stringBuilder.append((float)var1_1);
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        this.tilt = var1_1 + 0.0f;
        if ((double)var2_2 <= 0.0) {
            var2_2 = var2_2 % 360.0f + 360.0f;
        }
        this.bearing = var2_2 % 360.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        float f = this.tilt;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)2, (float)f);
        void v1 = var1_1;
        SafeParcelWriter.writeFloat((Parcel)v1, (int)3, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object o) {
        StreetViewPanoramaOrientation streetViewPanoramaOrientation;
        if (this == streetViewPanoramaOrientation) {
            return true;
        }
        if (!(streetViewPanoramaOrientation instanceof StreetViewPanoramaOrientation)) {
            return false;
        }
        streetViewPanoramaOrientation = streetViewPanoramaOrientation;
        return Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaOrientation.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaOrientation.bearing);
    }

    public static final class Builder {
        public float bearing;
        public float tilt;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder bearing(float bearing) {
            void var1_1;
            this.bearing = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder tilt(float tilt) {
            void var1_1;
            this.tilt = var1_1;
            return this;
        }

        @NonNull
        public StreetViewPanoramaOrientation build() {
            return new StreetViewPanoramaOrientation(this.tilt, this.bearing);
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull StreetViewPanoramaOrientation previous) {
            void var1_1;
            Preconditions.checkNotNull((Object)var1_1, (Object)"StreetViewPanoramaOrientation must not be null.");
            this.bearing = var1_1.bearing;
            this.tilt = var1_1.tilt;
        }
    }
}

