/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zza;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CameraPositionCreator")
public final class CameraPosition
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<CameraPosition> CREATOR = new zza();
    @SafeParcelable.Field(id=2)
    @NonNull
    public final LatLng target;
    @SafeParcelable.Field(id=3)
    public final float zoom;
    @SafeParcelable.Field(id=4)
    public final float tilt;
    @SafeParcelable.Field(id=5)
    public final float bearing;

    public int hashCode() {
        LatLng latLng = this.target;
        return Objects.hashCode((Object[])new Object[]{latLng, Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull CameraPosition camera) {
        CameraPosition cameraPosition;
        return new Builder(cameraPosition);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static CameraPosition createFromAttributes(@Nullable Context context, @Nullable AttributeSet attrs) {
        void var1_1;
        return GoogleMapOptions.zza(context, (AttributeSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static final CameraPosition fromLatLngZoom(@NonNull LatLng target, float zoom) {
        void var1_1;
        LatLng latLng;
        return new CameraPosition(latLng, (float)var1_1, 0.0f, 0.0f);
    }

    @NonNull
    public String toString() {
        float f = this.zoom;
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)((Object)this)).add("target", (Object)this.target).add("zoom", (Object)Float.valueOf(f));
        f = this.tilt;
        float f2 = this.bearing;
        return toStringHelper.add("tilt", (Object)Float.valueOf(f)).add("bearing", (Object)Float.valueOf(f2)).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public CameraPosition(@SafeParcelable.Param(id=2) @NonNull LatLng target, @SafeParcelable.Param(id=3) float zoom, @SafeParcelable.Param(id=4) float tilt, @SafeParcelable.Param(id=5) float bearing) {
        void var4_4;
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"camera target must not be null.");
        boolean bl = !(var3_3 < 0.0f) ? var3_3 <= 90.0f : false;
        Object[] objectArray = new Object[]{Float.valueOf((float)var3_3)};
        Preconditions.checkArgument((boolean)bl, (String)"Tilt needs to be between 0 and 90 inclusive: %s", (Object[])objectArray);
        this.target = var1_1;
        this.zoom = var2_2;
        this.tilt = var3_3 + 0.0f;
        if ((double)var4_4 <= 0.0) {
            var4_4 = var4_4 % 360.0f + 360.0f;
        }
        this.bearing = var4_4 % 360.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        LatLng latLng = this.target;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)latLng, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.zoom);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.tilt);
        void v1 = var1_1;
        SafeParcelWriter.writeFloat((Parcel)v1, (int)5, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        CameraPosition cameraPosition;
        if (this == cameraPosition) {
            return true;
        }
        if (!(cameraPosition instanceof CameraPosition)) {
            return false;
        }
        cameraPosition = cameraPosition;
        return this.target.equals((Object)cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public static final class Builder {
        private LatLng zza;
        private float zzb;
        private float zzc;
        private float zzd;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder bearing(float bearing) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder target(@NonNull LatLng location) {
            void var1_1;
            this.zza = (LatLng)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"location must not be null."));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder tilt(float tilt) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder zoom(float zoom) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public CameraPosition build() {
            return new CameraPosition(this.zza, this.zzb, this.zzc, this.zzd);
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull CameraPosition previous) {
            void var1_1;
            Builder builder = this;
            CameraPosition cameraPosition = (CameraPosition)((Object)Preconditions.checkNotNull((Object)var1_1, (Object)"previous must not be null."));
            builder.zza = cameraPosition.target;
            builder.zzb = cameraPosition.zoom;
            builder.zzc = cameraPosition.tilt;
            builder.zzd = cameraPosition.bearing;
        }
    }
}

