/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzk;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.OnMapsSdkInitializedCallback;
import com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate;
import com.google.android.gms.maps.internal.zzcc;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class MapsInitializer {
    private static final String zza = MapsInitializer.class.getSimpleName();
    private static boolean zzb = false;
    private static Renderer zzc = Renderer.LEGACY;

    public static synchronized int initialize(@NonNull Context context) {
        return MapsInitializer.initialize(context, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int initialize(@NonNull Context context, @Nullable Renderer preferredRenderer, @Nullable OnMapsSdkInitializedCallback callback) {
        int n;
        Context context2;
        void var2_7;
        Object object;
        block13: {
            block12: {
                void var1_5;
                Preconditions.checkNotNull((Object)context, (Object)"Context is null");
                object = String.valueOf(String.valueOf(var1_5));
                Log.d((String)zza, (String)"preferredRenderer: ".concat((String)object));
                if (zzb) {
                    if (var2_7 == null) return 0;
                    var2_7.onMapsSdkInitialized(zzc);
                    return 0;
                }
                try {
                    object = zzcc.zza(context2, (Renderer)var1_5);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return googlePlayServicesNotAvailableException.errorCode;
                }
                try {
                    ICameraUpdateFactoryDelegate iCameraUpdateFactoryDelegate = object.zze();
                    CameraUpdateFactory.zza(iCameraUpdateFactoryDelegate);
                    zzk zzk2 = object.zzj();
                    BitmapDescriptorFactory.zza(zzk2);
                    zzb = true;
                    if (var1_5 == null) break block12;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                switch (var1_5.ordinal()) {
                    default: {
                        n = 0;
                        break;
                    }
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                }
                break block13;
            }
            n = 0;
        }
        try {
            int n2 = object.zzd();
            if (n2 == 2) {
                zzc = Renderer.LATEST;
            }
            object.zzm(ObjectWrapper.wrap((Object)context2), n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)zza, (String)"Failed to retrieve renderer type or log initialization.", (Throwable)remoteException);
        }
        String string = String.valueOf(String.valueOf((Object)zzc));
        Log.d((String)zza, (String)"loadedRenderer: ".concat(string));
        if (var2_7 == null) return 0;
        var2_7.onMapsSdkInitialized(zzc);
        return 0;
    }

    private MapsInitializer() {
    }

    public static enum Renderer {
        LEGACY,
        LATEST;

    }
}

