/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.Objects;

public final class zzcc {
    private static final String zza = zzcc.class.getSimpleName();
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context zzb = null;
    private static zzf zzc;

    private static Context zzb(Exception exception, Context context) {
        Log.e((String)zza, (String)"Failed to load maps module, use pre-Chimera", (Throwable)exception);
        return GooglePlayServicesUtil.getRemoteContext((Context)context);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Context zzc(Context var0, @Nullable MapsInitializer.Renderer var1_1) {
        var2_2 = zzcc.zzb;
        if (var2_2 != null) {
            return var2_2;
        }
        var1_1 = var1_1 == MapsInitializer.Renderer.LEGACY ? "com.google.android.gms.maps_legacy_dynamite" : "com.google.android.gms.maps_core_dynamite";
        try {
            var0 = DynamiteModule.load((Context)var0, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)var1_1).getModuleContext();
lbl7:
            // 4 sources

            while (true) {
                zzcc.zzb = var0;
                if ((var0 = zzcc.zzb) != null) break block6;
                break;
            }
        }
        catch (Exception var2_3) {
            block7: {
                if (var1_1.equals("com.google.android.gms.maps_dynamite")) break block7;
                try {
                    Log.d((String)zzcc.zza, (String)"Attempting to load maps_dynamite again.");
                    var0 = DynamiteModule.load((Context)var0, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)"com.google.android.gms.maps_dynamite").getModuleContext();
                }
                catch (Exception v0) {
                    var0 = zzcc.zzb(v0, var0);
                }
                ** GOTO lbl7
            }
            var0 = zzcc.zzb(var2_3, var0);
            ** continue;
        }
        {
            block6: {
                throw new RuntimeException("Unable to load maps module, maps container context is null");
            }
            return var0;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzf zza(Context context, @Nullable MapsInitializer.Renderer renderer) throws GooglePlayServicesNotAvailableException {
        block13: {
            Preconditions.checkNotNull((Object)context);
            Object object = String.valueOf(String.valueOf((Object)renderer));
            Log.d((String)zza, (String)"preferredRenderer: ".concat((String)object));
            object = zzc;
            if (object != null) {
                return object;
            }
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context, (int)0xCC77C0);
            switch (n) {
                case 0: {
                    zzc = zzcc.zzd(context, renderer);
                    n = zzc.zzd();
                    String string = context.getPackageName();
                    if (n == 2 && !string.equals("com.google.android.apps.photos")) {
                        Log.d((String)zza, (String)"early loading native code");
                        zzc.zzn(ObjectWrapper.wrap((Object)zzcc.zzc(context, renderer)));
                    } else {
                        Log.d((String)zza, (String)"not early loading native code");
                    }
                    break block13;
                }
                default: {
                    throw new GooglePlayServicesNotAvailableException(n);
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Log.w((String)zza, (String)"Caught UnsatisfiedLinkError attempting to load the LATEST renderer's native library. Attempting to use the LEGACY renderer instead.");
                zzb = null;
                zzc = zzcc.zzd(context, MapsInitializer.Renderer.LEGACY);
            }
        }
        try {
            zzf zzf2 = zzc;
            context = ObjectWrapper.wrap((Object)Objects.requireNonNull(zzcc.zzc(context, renderer)).getResources());
            zzf2.zzl((IObjectWrapper)context, 19020000);
            return zzc;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static zzf zzd(Context object, @Nullable MapsInitializer.Renderer object2) {
        void var0_5;
        Object object3;
        void var1_8;
        Log.i((String)zza, (String)"Making Creator dynamically");
        ClassLoader classLoader = zzcc.zzc(object, (MapsInitializer.Renderer)var1_8).getClassLoader();
        String string = "com.google.android.gms.maps.internal.CreatorImpl";
        try {
            object3 = zzcc.zze(((ClassLoader)Preconditions.checkNotNull((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find dynamic class com.google.android.gms.maps.internal.CreatorImpl", classNotFoundException);
        }
        IBinder iBinder = (IBinder)object3;
        if (iBinder == null) {
            throw new RuntimeException("Unable to load maps module, IBinder for com.google.android.gms.maps.internal.CreatorImpl is null");
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICreator");
        if (iInterface instanceof zzf) {
            zzf zzf2 = (zzf)iInterface;
            return var0_5;
        }
        zze zze2 = new zze(iBinder);
        return var0_5;
    }

    private static Object zze(Class object) {
        try {
            object = ((Class)object).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            object = String.valueOf(((Class)object).getName());
            throw new IllegalStateException("Unable to call the default constructor of ".concat((String)object), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            object = String.valueOf(((Class)object).getName());
            throw new IllegalStateException("Unable to instantiate the dynamic class ".concat((String)object), instantiationException);
        }
        return object;
    }
}

