/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.maps.zzbo;
import com.google.android.gms.maps.model.FeatureType;
import com.google.android.gms.maps.model.zzf;
import com.google.android.gms.maps.model.zzg;

@SafeParcelable.Class(creator="FeatureLayerOptionsCreator")
public final class FeatureLayerOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<FeatureLayerOptions> CREATOR = new zzg();
    private static final zzbo zza;
    @FeatureType
    @SafeParcelable.Field(id=1, getter="getFeatureType")
    private final String zzb;
    @SafeParcelable.Field(id=2, getter="getDatasetId")
    private final String zzc;

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public String getDatasetId() {
        return this.zzc;
    }

    @FeatureType
    @NonNull
    public String getFeatureType() {
        return this.zzb;
    }

    static {
        String string = "DATASET";
        Object[] objectArray = new String[]{string};
        zza = zzbo.zzi("ADMINISTRATIVE_AREA_LEVEL_1", "ADMINISTRATIVE_AREA_LEVEL_2", "COUNTRY", "LOCALITY", "POSTAL_CODE", "SCHOOL_DISTRICT", objectArray);
    }

    @SafeParcelable.Constructor
    FeatureLayerOptions(@FeatureType @SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) String string2) {
        this.zzb = string;
        this.zzc = string2;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.getFeatureType(), (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)this.getDatasetId(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ FeatureLayerOptions(Builder builder, zzf zzf2) {
        this.zzb = builder.zza;
        this.zzc = builder.zzb;
    }

    public static final class Builder {
        private String zza;
        private String zzb;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder datasetId(@NonNull String datasetId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder featureType(@FeatureType @NonNull String featureType) {
            void var1_1;
            Preconditions.checkArgument((boolean)zza.contains(var1_1), (Object)"Invalid FeatureType value");
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public FeatureLayerOptions build() {
            String string = this.zza;
            if (string == null) {
                throw new IllegalArgumentException("FeatureType must be specified.");
            }
            if (string.equals("DATASET") && this.zzb == null) {
                throw new IllegalArgumentException("A datasetId must be specified for DATASET feature layers.");
            }
            return new FeatureLayerOptions(this, null);
        }
    }
}

