/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.zzj;
import com.google.android.gms.maps.model.zzr;
import java.util.Objects;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PinConfigCreator")
public class PinConfig
extends AbstractSafeParcelable {
    public static final int BITMAP_WIDTH_DP = 26;
    public static final int BITMAP_LENGTH_DP = 37;
    @NonNull
    public static final Parcelable.Creator<PinConfig> CREATOR = new zzr();
    public static final int DEFAULT_PIN_BACKGROUND_COLOR = -1424587;
    public static final int DEFAULT_PIN_BORDER_COLOR = -3857889;
    public static final int DEFAULT_PIN_GLYPH_COLOR = -5041134;
    @SafeParcelable.Field(id=2, getter="getBackgroundColor")
    private final int zza;
    @SafeParcelable.Field(id=3, getter="getBorderColor")
    private final int zzb;
    @SafeParcelable.Field(id=4, getter="getGlyph")
    private final Glyph zzc;

    public int getBackgroundColor() {
        return this.zza;
    }

    public int getBorderColor() {
        return this.zzb;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public Glyph getGlyph() {
        return this.zzc;
    }

    @SafeParcelable.Constructor
    PinConfig(@SafeParcelable.Param(id=2) @ColorInt int n, @SafeParcelable.Param(id=3) @ColorInt int n2, @SafeParcelable.Param(id=4) Glyph glyph) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = glyph;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getBackgroundColor());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getBorderColor());
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, (int)4, (Parcelable)this.getGlyph(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    @SafeParcelable.Reserved(value={1})
    @SafeParcelable.Class(creator="GlyphCreator")
    public static class Glyph
    extends AbstractSafeParcelable {
        @NonNull
        public static final Parcelable.Creator<Glyph> CREATOR = new zzj();
        public static final float X_COORDINATE_DP = 13.0f;
        public static final float Y_COORDINATE_DP = 13.0f;
        public static final float DEFAULT_CIRCLE_RADIUS_DP = 5.0f;
        @SafeParcelable.Field(id=2, getter="getText")
        @Nullable
        private String zza;
        @SafeParcelable.Field(id=3, getter="getWrappedBitmapDescriptorBinder", type="android.os.IBinder")
        @Nullable
        private BitmapDescriptor zzb;
        @SafeParcelable.Field(id=4, getter="getGlyphColor")
        private int zzc;
        @SafeParcelable.Field(id=5, getter="getTextColor")
        @ColorInt
        private int zzd;

        public int getGlyphColor() {
            return this.zzc;
        }

        public int getTextColor() {
            return this.zzd;
        }

        public int hashCode() {
            return Objects.hash(this.zza, this.zzb, this.zzc);
        }

        @Nullable
        public BitmapDescriptor getBitmapDescriptor() {
            return this.zzb;
        }

        @Nullable
        public String getText() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        public Glyph(@ColorInt int glyphColor) {
            void var1_1;
            this.zzd = -16777216;
            this.zzc = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Glyph(@Nullable BitmapDescriptor bitmapDescriptor) {
            void var1_1;
            this.zzc = -5041134;
            this.zzd = -16777216;
            this.zzb = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Glyph(@NonNull String text) {
            this((String)var1_1, -16777216);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Glyph(@NonNull String text, @ColorInt int textColor) {
            void var2_2;
            void var1_1;
            this.zzc = -5041134;
            this.zza = var1_1;
            this.zzd = var2_2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @SafeParcelable.Constructor
        Glyph(@SafeParcelable.Param(id=2) String object, @SafeParcelable.Param(id=3) IBinder iBinder, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) int n2) {
            this.zzc = -5041134;
            this.zzd = -16777216;
            this.zza = object;
            object = iBinder == null ? null : new BitmapDescriptor(IObjectWrapper.Stub.asInterface((IBinder)iBinder));
            this.zzb = object;
            this.zzc = n;
            this.zzd = n2;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public void writeToParcel(@NonNull Parcel out, int n) {
            void var1_1;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getText(), (boolean)false);
            BitmapDescriptor bitmapDescriptor = this.zzb;
            bitmapDescriptor = bitmapDescriptor == null ? null : bitmapDescriptor.zza().asBinder();
            SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)3, (IBinder)bitmapDescriptor, (boolean)false);
            SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getGlyphColor());
            SafeParcelWriter.writeInt((Parcel)var1_1, (int)5, (int)this.getTextColor());
            SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
        }

        public boolean equals(@Nullable Object o) {
            Object object;
            if (this_ == object) {
                return true;
            }
            if (!(object instanceof Glyph)) {
                return false;
            }
            object = (Glyph)((Object)object);
            if (((Glyph)((Object)this_)).zzc != ((Glyph)((Object)object)).zzc || !Objects.equals(((Glyph)((Object)this_)).zza, ((Glyph)((Object)object)).zza) || ((Glyph)((Object)this_)).zzd != ((Glyph)((Object)object)).zzd) {
                return false;
            }
            BitmapDescriptor this_ = ((Glyph)((Object)this_)).zzb;
            if (!(this_ == null && ((Glyph)((Object)object)).zzb != null || this_ != null && ((Glyph)((Object)object)).zzb == null)) {
                object = ((Glyph)((Object)object)).zzb;
                if (this_ != null && object != null) {
                    return Objects.equals(ObjectWrapper.unwrap((IObjectWrapper)this_.zza()), ObjectWrapper.unwrap((IObjectWrapper)((BitmapDescriptor)object).zza()));
                }
                return true;
            }
            return false;
        }
    }

    public static class Builder {
        private int zza = -1424587;
        private int zzb = -3857889;
        private Glyph zzc = new Glyph(-5041134);

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBorderColor(@ColorInt int borderColor) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGlyph(@NonNull Glyph glyph) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        @NonNull
        public PinConfig build() {
            return new PinConfig(this.zza, this.zzb, this.zzc);
        }
    }
}

