/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzy;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaLinkCreator")
public class StreetViewPanoramaLink
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<StreetViewPanoramaLink> CREATOR = new zzy();
    @SafeParcelable.Field(id=2)
    @NonNull
    public final String panoId;
    @SafeParcelable.Field(id=3)
    public final float bearing;

    public int hashCode() {
        String string = this.panoId;
        return Objects.hashCode((Object[])new Object[]{string, Float.valueOf(this.bearing)});
    }

    @NonNull
    public String toString() {
        float f = this.bearing;
        return Objects.toStringHelper((Object)((Object)this)).add("panoId", (Object)this.panoId).add("bearing", (Object)Float.valueOf(f)).toString();
    }

    @SafeParcelable.Constructor
    public StreetViewPanoramaLink(@SafeParcelable.Param(id=2) @NonNull String string, @SafeParcelable.Param(id=3) float f) {
        this.panoId = string;
        if ((double)f <= 0.0) {
            f = f % 360.0f + 360.0f;
        }
        this.bearing = f % 360.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        String string = this.panoId;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)string, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeFloat((Parcel)v1, (int)3, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object o) {
        StreetViewPanoramaLink streetViewPanoramaLink;
        if (this == streetViewPanoramaLink) {
            return true;
        }
        if (!(streetViewPanoramaLink instanceof StreetViewPanoramaLink)) {
            return false;
        }
        streetViewPanoramaLink = streetViewPanoramaLink;
        return this.panoId.equals(streetViewPanoramaLink.panoId) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaLink.bearing);
    }
}

