/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzy {
    private static Context zzauP;
    private static zzc zzauQ;

    public static zzc zzah(Context context) throws GooglePlayServicesNotAvailableException {
        zzv.zzr((Object)context);
        if (zzauQ != null) {
            return zzauQ;
        }
        zzy.zzai(context);
        zzauQ = zzy.zzaj(context);
        try {
            zzauQ.zzb(zze.zzt((Object)zzy.getRemoteContext(context).getResources()), 7327000);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzauQ;
    }

    public static boolean zztN() {
        return false;
    }

    private static Class<?> zztO() {
        try {
            if (Build.VERSION.SDK_INT < 15) {
                return Class.forName("com.google.android.gms.maps.internal.CreatorImplGmm6");
            }
            return Class.forName("com.google.android.gms.maps.internal.CreatorImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static void zzai(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzaj(Context context) {
        if (zzy.zztN()) {
            Log.i((String)zzy.class.getSimpleName(), (String)"Making Creator statically");
            Class<?> clazz = zzy.zztO();
            return (zzc)zzy.zzc(clazz);
        }
        Log.i((String)zzy.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzy.zza(zzy.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzbq(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (zzauP == null) {
            zzauP = zzy.zztN() ? context.getApplicationContext() : GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return zzauP;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzy.zzc(((ClassLoader)zzv.zzr((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find dynamic class " + string);
        }
    }

    private static <T> T zzc(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Unable to instantiate the dynamic class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unable to call the default constructor of " + clazz.getName());
        }
    }
}

