/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzy {
    private static Context zzaJF;
    private static zzc zzaJG;

    public static zzc zzaG(Context context) throws GooglePlayServicesNotAvailableException {
        zzx.zzw((Object)context);
        if (zzaJG != null) {
            return zzaJG;
        }
        zzy.zzaH(context);
        zzaJG = zzy.zzaI(context);
        try {
            zzaJG.zzd(zze.zzy((Object)zzy.getRemoteContext(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzaJG;
    }

    public static boolean zzxV() {
        return false;
    }

    private static Class<?> zzxW() {
        try {
            return Class.forName("com.google.android.gms.maps.internal.CreatorImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static void zzaH(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzaI(Context context) {
        if (zzy.zzxV()) {
            Log.i((String)zzy.class.getSimpleName(), (String)"Making Creator statically");
            Class<?> clazz = zzy.zzxW();
            return (zzc)zzy.zzc(clazz);
        }
        Log.i((String)zzy.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzy.zza(zzy.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzcl(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (zzaJF == null) {
            zzaJF = zzy.zzxV() ? context.getApplicationContext() : GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return zzaJF;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzy.zzc(((ClassLoader)zzx.zzw((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find dynamic class " + string);
        }
    }

    private static <T> T zzc(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Unable to instantiate the dynamic class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unable to call the default constructor of " + clazz.getName());
        }
    }
}

