/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor zzaQm;
    private LatLng zzaQn;
    private float zzaQo;
    private float zzaQp;
    private LatLngBounds zzaQq;
    private float zzaQc;
    private float zzaQj;
    private boolean zzaQk = true;
    private float zzaQr = 0.0f;
    private float zzaQs = 0.5f;
    private float zzaQt = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.mVersionCode = versionCode;
        this.zzaQm = new BitmapDescriptor(zzd.zza.zzbs((IBinder)wrappedImage));
        this.zzaQn = location;
        this.zzaQo = width;
        this.zzaQp = height;
        this.zzaQq = bounds;
        this.zzaQc = bearing;
        this.zzaQj = zIndex;
        this.zzaQk = visible;
        this.zzaQr = transparency;
        this.zzaQs = anchorU;
        this.zzaQt = anchorV;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    IBinder zzzu() {
        return this.zzaQm.zzyS().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zzaQm = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u, float v) {
        this.zzaQs = u;
        this.zzaQt = v;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        zzx.zza((this.zzaQq == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        zzx.zza((this.zzaQq == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzx.zzb((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzx.zzb((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzx.zzb((height >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(location, width, height);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzaQn = latLng;
        this.zzaQo = f;
        this.zzaQp = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        zzx.zza((this.zzaQn == null ? 1 : 0) != 0, (Object)("Position has already been set using position: " + this.zzaQn));
        this.zzaQq = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zzaQc = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zzaQj = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zzaQk = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        zzx.zzb((transparency >= 0.0f && transparency <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzaQr = transparency;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.zzaQm;
    }

    public LatLng getLocation() {
        return this.zzaQn;
    }

    public float getWidth() {
        return this.zzaQo;
    }

    public float getHeight() {
        return this.zzaQp;
    }

    public LatLngBounds getBounds() {
        return this.zzaQq;
    }

    public float getBearing() {
        return this.zzaQc;
    }

    public float getZIndex() {
        return this.zzaQj;
    }

    public float getTransparency() {
        return this.zzaQr;
    }

    public float getAnchorU() {
        return this.zzaQs;
    }

    public float getAnchorV() {
        return this.zzaQt;
    }

    public boolean isVisible() {
        return this.zzaQk;
    }
}

