/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzd;

public final class LatLngBounds
implements SafeParcelable {
    public static final zzd CREATOR = new zzd();
    private final int mVersionCode;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        zzx.zzb((Object)southwest, (Object)"null southwest");
        zzx.zzb((Object)northeast, (Object)"null northeast");
        zzx.zzb((northeast.latitude >= southwest.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{southwest.latitude, northeast.latitude});
        this.mVersionCode = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.zzi(latLng.latitude) && this.zzj(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d = Math.min(this.southwest.latitude, latLng.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng.longitude;
        if (!this.zzj(d5)) {
            if (LatLngBounds.zzb(d4, d5) < LatLngBounds.zzc(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public LatLng getCenter() {
        double d = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        double d4 = d2 <= d3 ? (d3 + d2) / 2.0 : (d3 + 360.0 + d2) / 2.0;
        return new LatLng(d, d4);
    }

    private static double zzb(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzc(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private boolean zzi(double d) {
        return this.southwest.latitude <= d && d <= this.northeast.latitude;
    }

    private boolean zzj(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("southwest", (Object)this.southwest).zzg("northeast", (Object)this.northeast).toString();
    }

    public static final class Builder {
        private double zzaQw = Double.POSITIVE_INFINITY;
        private double zzaQx = Double.NEGATIVE_INFINITY;
        private double zzaQy = Double.NaN;
        private double zzaQz = Double.NaN;

        public Builder include(LatLng point) {
            this.zzaQw = Math.min(this.zzaQw, point.latitude);
            this.zzaQx = Math.max(this.zzaQx, point.latitude);
            double d = point.longitude;
            if (Double.isNaN(this.zzaQy)) {
                this.zzaQy = d;
                this.zzaQz = d;
            } else if (!this.zzj(d)) {
                if (LatLngBounds.zzb(this.zzaQy, d) < LatLngBounds.zzc(this.zzaQz, d)) {
                    this.zzaQy = d;
                } else {
                    this.zzaQz = d;
                }
            }
            return this;
        }

        private boolean zzj(double d) {
            if (this.zzaQy <= this.zzaQz) {
                return this.zzaQy <= d && d <= this.zzaQz;
            }
            return this.zzaQy <= d || d <= this.zzaQz;
        }

        public LatLngBounds build() {
            zzx.zza((!Double.isNaN(this.zzaQy) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zzaQw, this.zzaQy), new LatLng(this.zzaQx, this.zzaQz));
        }
    }
}

