/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zza;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int mVersionCode;
    private Boolean zzaRP;
    private Boolean zzaRQ;
    private int zzaRR = -1;
    private CameraPosition zzaRS;
    private Boolean zzaRT;
    private Boolean zzaRU;
    private Boolean zzaRV;
    private Boolean zzaRW;
    private Boolean zzaRX;
    private Boolean zzaRY;
    private Boolean zzaRZ;
    private Boolean zzaSa;
    private Boolean zzaSb;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled, byte liteMode, byte mapToolbarEnabled, byte ambientEnabled) {
        this.mVersionCode = versionCode;
        this.zzaRP = com.google.android.gms.maps.internal.zza.zza(zOrderOnTop);
        this.zzaRQ = com.google.android.gms.maps.internal.zza.zza(useViewLifecycleInFragment);
        this.zzaRR = mapType;
        this.zzaRS = camera;
        this.zzaRT = com.google.android.gms.maps.internal.zza.zza(zoomControlsEnabled);
        this.zzaRU = com.google.android.gms.maps.internal.zza.zza(compassEnabled);
        this.zzaRV = com.google.android.gms.maps.internal.zza.zza(scrollGesturesEnabled);
        this.zzaRW = com.google.android.gms.maps.internal.zza.zza(zoomGesturesEnabled);
        this.zzaRX = com.google.android.gms.maps.internal.zza.zza(tiltGesturesEnabled);
        this.zzaRY = com.google.android.gms.maps.internal.zza.zza(rotateGesturesEnabled);
        this.zzaRZ = com.google.android.gms.maps.internal.zza.zza(liteMode);
        this.zzaSa = com.google.android.gms.maps.internal.zza.zza(mapToolbarEnabled);
        this.zzaSb = com.google.android.gms.maps.internal.zza.zza(ambientEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzzK() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRP);
    }

    byte zzzL() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRQ);
    }

    byte zzzM() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRT);
    }

    byte zzzN() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRU);
    }

    byte zzzO() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRV);
    }

    byte zzzP() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRW);
    }

    byte zzzQ() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRX);
    }

    byte zzzR() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRY);
    }

    byte zzzS() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaRZ);
    }

    byte zzzT() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaSa);
    }

    byte zzzU() {
        return com.google.android.gms.maps.internal.zza.zze(this.zzaSb);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.zzaRP = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.zzaRQ = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.zzaRR = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.zzaRS = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.zzaRT = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.zzaRU = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.zzaRV = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zzaRW = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.zzaRX = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.zzaRY = enabled;
        return this;
    }

    public GoogleMapOptions liteMode(boolean enabled) {
        this.zzaRZ = enabled;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        this.zzaSa = enabled;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean enabled) {
        this.zzaSb = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzaRP;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzaRQ;
    }

    public int getMapType() {
        return this.zzaRR;
    }

    public CameraPosition getCamera() {
        return this.zzaRS;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzaRT;
    }

    public Boolean getCompassEnabled() {
        return this.zzaRU;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzaRV;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzaRW;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzaRX;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzaRY;
    }

    public Boolean getLiteMode() {
        return this.zzaRZ;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzaSa;
    }

    public Boolean getAmbientEnabled() {
        return this.zzaSb;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

