/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzad;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaSj;
    private GoogleMap zzaSd;

    public MapView(Context context) {
        super(context);
        this.zzaSj = new zzb((ViewGroup)this, context, null);
        this.zzex();
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzaSj = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.zzex();
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzaSj = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.zzex();
    }

    public MapView(Context context, GoogleMapOptions options) {
        super(context);
        this.zzaSj = new zzb((ViewGroup)this, context, options);
        this.zzex();
    }

    private void zzex() {
        this.setClickable(true);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzaSd != null) {
            return this.zzaSd;
        }
        this.zzaSj.zzzW();
        if (this.zzaSj.zztU() == null) {
            return null;
        }
        try {
            this.zzaSd = new GoogleMap(((zza)this.zzaSj.zztU()).zzzX().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzaSd;
    }

    public final void onCreate(Bundle savedInstanceState) {
        this.zzaSj.onCreate(savedInstanceState);
        if (this.zzaSj.zztU() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzaSj.onResume();
    }

    public final void onPause() {
        this.zzaSj.onPause();
    }

    public final void onDestroy() {
        this.zzaSj.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaSj.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle outState) {
        this.zzaSj.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzx.zzcD((String)"getMapAsync() must be called on the main thread");
        this.zzaSj.getMapAsync(callback);
    }

    public final void onEnterAmbient(Bundle ambientDetails) {
        zzx.zzcD((String)"onEnterAmbient() must be called on the main thread");
        this.zzaSj.onEnterAmbient(ambientDetails);
    }

    public final void onExitAmbient() {
        zzx.zzcD((String)"onExitAmbient() must be called on the main thread");
        this.zzaSj.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzaSo;
        private final Context mContext;
        protected zzf<zza> zzaSh;
        private final GoogleMapOptions zzaSp;
        private final List<OnMapReadyCallback> zzaSi = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzaSo = viewGroup;
            this.mContext = context;
            this.zzaSp = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaSh = zzf2;
            this.zzzW();
        }

        public void zzzW() {
            if (this.zzaSh != null && this.zztU() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzad.zzaO(this.mContext).zza(zze.zzC((Object)this.mContext), this.zzaSp);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzaSh.zza((LifecycleDelegate)new zza(this.zzaSo, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaSi) {
                        ((zza)this.zztU()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaSi.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zztU() != null) {
                ((zza)this.zztU()).getMapAsync(callback);
            } else {
                this.zzaSi.add(callback);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            if (this.zztU() != null) {
                ((zza)this.zztU()).onEnterAmbient(ambientDetails);
            }
        }

        public void onExitAmbient() {
            if (this.zztU() != null) {
                ((zza)this.zztU()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzaSk;
        private final IMapViewDelegate zzaSl;
        private View zzaSm;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaSl = (IMapViewDelegate)zzx.zzz((Object)iMapViewDelegate);
            this.zzaSk = (ViewGroup)zzx.zzz((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaSl.onCreate(savedInstanceState);
                this.zzaSm = (View)zze.zzp((zzd)this.zzaSl.getView());
                this.zzaSk.removeAllViews();
                this.zzaSk.addView(this.zzaSm);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaSl.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaSl.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzaSl.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaSl.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaSl.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zzzX() {
            return this.zzaSl;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaSl.getMapAsync(new zzo.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            try {
                this.zzaSl.onEnterAmbient(ambientDetails);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaSl.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

