/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzac;
import com.google.android.gms.maps.internal.zzad;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    private final zzb zzaSP = new zzb(this);
    private GoogleMap zzaSd;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions options) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    protected IMapFragmentDelegate zzzV() {
        this.zzaSP.zzzW();
        if (this.zzaSP.zztU() == null) {
            return null;
        }
        return ((zza)this.zzaSP.zztU()).zzzV();
    }

    @Deprecated
    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.zzzV();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.zzaSd == null || this.zzaSd.zzzJ().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.zzaSd = new GoogleMap(iGoogleMapDelegate);
        }
        return this.zzaSd;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzaSP.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.zzaSP.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzaSP.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zzaSP.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.zzaSP.onCreateView(inflater, container, savedInstanceState);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzaSP.onResume();
    }

    public void onPause() {
        this.zzaSP.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.zzaSP.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzaSP.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzaSP.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.zzaSP.onSaveInstanceState(outState);
    }

    public final void onEnterAmbient(Bundle ambientDetails) {
        zzx.zzcD((String)"onEnterAmbient must be called on the main thread.");
        this.zzaSP.onEnterAmbient(ambientDetails);
    }

    public final void onExitAmbient() {
        zzx.zzcD((String)"onExitAmbient must be called on the main thread.");
        this.zzaSP.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzx.zzcD((String)"getMapAsync must be called on the main thread.");
        this.zzaSP.getMapAsync(callback);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzalg;
        protected zzf<zza> zzaSh;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzaSi = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzalg = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaSh = zzf2;
            this.zzzW();
        }

        public void zzzW() {
            if (this.mActivity != null && this.zzaSh != null && this.zztU() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzad.zzaO((Context)this.mActivity).zzs(zze.zzC((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzaSh.zza((LifecycleDelegate)new zza(this.zzalg, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaSi) {
                        ((zza)this.zztU()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaSi.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzzW();
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zztU() != null) {
                ((zza)this.zztU()).getMapAsync(callback);
            } else {
                this.zzaSi.add(callback);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            if (this.zztU() != null) {
                ((zza)this.zztU()).onEnterAmbient(ambientDetails);
            }
        }

        public void onExitAmbient() {
            if (this.zztU() != null) {
                ((zza)this.zztU()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment zzalg;
        private final IMapFragmentDelegate zzaSe;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzaSe = (IMapFragmentDelegate)zzx.zzz((Object)iMapFragmentDelegate);
            this.zzalg = (Fragment)zzx.zzz((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.zzaSe.onInflate(zze.zzC((Object)activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.zzalg.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    zzac.zza(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.zzaSe.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            zzd zzd2;
            try {
                zzd2 = this.zzaSe.onCreateView(zze.zzC((Object)inflater), zze.zzC((Object)container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzp((zzd)zzd2);
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaSe.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaSe.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            try {
                this.zzaSe.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.zzaSe.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaSe.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaSe.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate zzzV() {
            return this.zzaSe;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaSe.getMapAsync(new zzo.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            try {
                this.zzaSe.onEnterAmbient(ambientDetails);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaSe.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

