/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzad {
    private static Context zzaSU;
    private static zzc zzaSV;

    public static zzc zzaO(Context context) throws GooglePlayServicesNotAvailableException {
        zzx.zzz((Object)context);
        if (zzaSV != null) {
            return zzaSV;
        }
        zzad.zzaP(context);
        zzaSV = zzad.zzaQ(context);
        try {
            zzaSV.zzd(zze.zzC((Object)zzad.getRemoteContext(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzaSV;
    }

    public static boolean zzAg() {
        return false;
    }

    private static Class<?> zzAh() {
        try {
            return Class.forName("com.google.android.gms.maps.internal.CreatorImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static void zzaP(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzaQ(Context context) {
        if (zzad.zzAg()) {
            Log.i((String)zzad.class.getSimpleName(), (String)"Making Creator statically");
            Class<?> clazz = zzad.zzAh();
            return (zzc)zzad.zzd(clazz);
        }
        Log.i((String)zzad.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzad.zza(zzad.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzcu(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (zzaSU == null) {
            zzaSU = zzad.zzAg() ? context.getApplicationContext() : GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return zzaSU;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzad.zzd(((ClassLoader)zzx.zzz((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find dynamic class " + string);
        }
    }

    private static <T> T zzd(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Unable to instantiate the dynamic class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unable to call the default constructor of " + clazz.getName());
        }
    }
}

