/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzb;
import com.google.firebase.analytics.connector.internal.zze;
import com.google.firebase.analytics.connector.internal.zzg;
import com.google.firebase.analytics.connector.zza;
import com.google.firebase.events.Event;
import com.google.firebase.events.Subscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private static volatile AnalyticsConnector zzb;
    @VisibleForTesting
    private final AppMeasurement zzc;
    @VisibleForTesting
    final Map<String, com.google.firebase.analytics.connector.internal.zza> zza;

    private AnalyticsConnectorImpl(AppMeasurement appMeasurement) {
        Preconditions.checkNotNull((Object)appMeasurement);
        this.zzc = appMeasurement;
        this.zza = new ConcurrentHashMap<String, com.google.firebase.analytics.connector.internal.zza>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp, Context context, Subscriber subscriber) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)subscriber);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb != null) return zzb;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            if (zzb != null) return zzb;
            Bundle bundle = new Bundle(1);
            if (firebaseApp.isDefaultApp()) {
                subscriber.subscribe(DataCollectionDefaultChange.class, com.google.firebase.analytics.connector.zza.zza, com.google.firebase.analytics.connector.zzb.zza);
                bundle.putBoolean("dataCollectionDefaultEnabled", firebaseApp.isDataCollectionDefaultEnabled());
            }
            zzb = new AnalyticsConnectorImpl(AppMeasurement.zza((Context)context, (Bundle)bundle));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzb;
        }
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp) {
        return (AnalyticsConnector)firebaseApp.get(AnalyticsConnector.class);
    }

    @KeepForSdk
    public void logEvent(@NonNull String string, @NonNull String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string2, bundle)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string, string2, bundle)) {
            return;
        }
        com.google.firebase.analytics.connector.internal.zzb.zzb(string, string2, bundle);
        this.zzc.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void setUserProperty(@NonNull String string, @NonNull String string2, Object object) {
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string, string2)) {
            return;
        }
        this.zzc.setUserPropertyInternal(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zzc.getUserProperties(bl);
    }

    @WorkerThread
    @KeepForSdk
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(final @NonNull String string, AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener) {
        com.google.firebase.analytics.connector.internal.zza zza2;
        Preconditions.checkNotNull((Object)analyticsConnectorListener);
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string)) {
            return null;
        }
        if (this.zza(string)) {
            return null;
        }
        AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener2 = analyticsConnectorListener;
        AppMeasurement appMeasurement = this.zzc;
        String string2 = string;
        if (("fiam".equals(string2) ? new zze(appMeasurement, analyticsConnectorListener2) : (zza2 = "crash".equals(string2) || "clx".equals(string2) ? new zzg(appMeasurement, analyticsConnectorListener2) : null)) != null) {
            this.zza.put(string, zza2);
            return new AnalyticsConnector.AnalyticsConnectorHandle(){

                public void unregister() {
                    if (!AnalyticsConnectorImpl.this.zza(string)) {
                        return;
                    }
                    AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = AnalyticsConnectorImpl.this.zza.get(string).zza();
                    if (analyticsConnectorListener != null) {
                        analyticsConnectorListener.onMessageTriggered(0, null);
                    }
                    AnalyticsConnectorImpl.this.zza.remove(string);
                }

                @KeepForSdk
                public void registerEventNames(Set<String> set) {
                    if (!AnalyticsConnectorImpl.this.zza(string) || !string.equals("fiam") || set == null || set.isEmpty()) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zza.get(string).zza(set);
                }

                @KeepForSdk
                public void unregisterEventNames() {
                    if (!AnalyticsConnectorImpl.this.zza(string) || !string.equals("fiam")) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zza.get(string).zzb();
                }
            };
        }
        return null;
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(conditionalUserProperty)) {
            return;
        }
        this.zzc.setConditionalUserProperty(com.google.firebase.analytics.connector.internal.zzb.zzb(conditionalUserProperty));
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (string2 != null && !com.google.firebase.analytics.connector.internal.zzb.zza(string2, bundle)) {
            return;
        }
        this.zzc.clearConditionalUserProperty(string, string2, bundle);
    }

    @WorkerThread
    @KeepForSdk
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@NonNull String string, @Nullable @Size(min=1L, max=23L) String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = this.zzc.getConditionalUserProperties(string, string2).iterator();
        while (iterator.hasNext()) {
            AnalyticsConnector.ConditionalUserProperty conditionalUserProperty = com.google.firebase.analytics.connector.internal.zzb.zza((AppMeasurement.ConditionalUserProperty)iterator.next());
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzc.getMaxUserProperties(string);
    }

    private final boolean zza(@NonNull String string) {
        return !string.isEmpty() && this.zza.containsKey(string) && this.zza.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void zza(Event event) {
        boolean bl = ((DataCollectionDefaultChange)event.getPayload()).enabled;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            ((AnalyticsConnectorImpl)AnalyticsConnectorImpl.zzb).zzc.zza(bl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

