/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzug;
import com.google.android.gms.internal.measurement.zzum;
import com.google.android.gms.internal.measurement.zzun;
import com.google.android.gms.internal.measurement.zzvf;
import com.google.android.gms.internal.measurement.zzvg;
import com.google.android.gms.internal.measurement.zzvz;
import com.google.android.gms.internal.measurement.zzwl;
import com.google.android.gms.internal.measurement.zzxe;
import com.google.android.gms.internal.measurement.zzxu;
import com.google.android.gms.internal.measurement.zzys;
import com.google.android.gms.internal.measurement.zzyu;
import com.google.android.gms.internal.measurement.zzyy;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzve
extends zzum {
    private static final Logger logger = Logger.getLogger(zzve.class.getName());
    private static final boolean zzbvq = zzys.zzyv();
    zzvg zzbvr;

    public static zzve zzj(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzve zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzys.zzyw()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzve() {
    }

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public abstract void zze(int var1, int var2) throws IOException;

    public final void zzf(int n, int n2) throws IOException {
        this.zze(n, zzve.zzbj(n2));
    }

    public abstract void zzg(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzve.zzbg(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzg(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zzb(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzun var2) throws IOException;

    public abstract void zza(int var1, zzxe var2) throws IOException;

    abstract void zza(int var1, zzxe var2, zzxu var3) throws IOException;

    public abstract void zzb(int var1, zzxe var2) throws IOException;

    public abstract void zzb(int var1, zzun var2) throws IOException;

    public abstract void zzay(int var1) throws IOException;

    public abstract void zzaz(int var1) throws IOException;

    public final void zzba(int n) throws IOException {
        this.zzaz(zzve.zzbj(n));
    }

    public abstract void zzbb(int var1) throws IOException;

    public abstract void zzay(long var1) throws IOException;

    public final void zzaz(long l) throws IOException {
        this.zzay(zzve.zzbg(l));
    }

    public abstract void zzba(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzbb(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzba(Double.doubleToRawLongBits(d));
    }

    public final void zzs(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzgd(String var1) throws IOException;

    public abstract void zza(zzun var1) throws IOException;

    public abstract void zzb(zzxe var1) throws IOException;

    abstract void zza(zzxe var1, zzxu var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzh(int n, int n2) {
        return zzve.zzbc(n) + zzve.zzbd(n2);
    }

    public static int zzi(int n, int n2) {
        return zzve.zzbc(n) + zzve.zzbe(n2);
    }

    public static int zzj(int n, int n2) {
        return zzve.zzbc(n) + zzve.zzbe(zzve.zzbj(n2));
    }

    public static int zzk(int n, int n2) {
        return zzve.zzbc(n) + 4;
    }

    public static int zzl(int n, int n2) {
        return zzve.zzbc(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzve.zzbc(n) + zzve.zzbc(l);
    }

    public static int zze(int n, long l) {
        return zzve.zzbc(n) + zzve.zzbc(l);
    }

    public static int zzf(int n, long l) {
        return zzve.zzbc(n) + zzve.zzbc(zzve.zzbg(l));
    }

    public static int zzg(int n, long l) {
        return zzve.zzbc(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzve.zzbc(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzve.zzbc(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzve.zzbc(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzve.zzbc(n) + 1;
    }

    public static int zzm(int n, int n2) {
        return zzve.zzbc(n) + zzve.zzbd(n2);
    }

    public static int zzc(int n, String string) {
        return zzve.zzbc(n) + zzve.zzge(string);
    }

    public static int zzc(int n, zzun zzun2) {
        int n2 = zzun2.size();
        return zzve.zzbc(n) + (zzve.zzbe(n2) + n2);
    }

    public static int zza(int n, zzwl zzwl2) {
        int n2 = zzwl2.zzwe();
        return zzve.zzbc(n) + (zzve.zzbe(n2) + n2);
    }

    public static int zzc(int n, zzxe zzxe2) {
        return zzve.zzbc(n) + zzve.zzc(zzxe2);
    }

    static int zzb(int n, zzxe zzxe2, zzxu zzxu2) {
        return zzve.zzbc(n) + zzve.zzb(zzxe2, zzxu2);
    }

    public static int zzd(int n, zzxe zzxe2) {
        return (zzve.zzbc(1) << 1) + zzve.zzi(2, n) + zzve.zzc(3, zzxe2);
    }

    public static int zzd(int n, zzun zzun2) {
        return (zzve.zzbc(1) << 1) + zzve.zzi(2, n) + zzve.zzc(3, zzun2);
    }

    public static int zzb(int n, zzwl zzwl2) {
        return (zzve.zzbc(1) << 1) + zzve.zzi(2, n) + zzve.zza(3, zzwl2);
    }

    public static int zzbc(int n) {
        return zzve.zzbe(n << 3);
    }

    public static int zzbd(int n) {
        if (n >= 0) {
            return zzve.zzbe(n);
        }
        return 10;
    }

    public static int zzbe(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzbf(int n) {
        return zzve.zzbe(zzve.zzbj(n));
    }

    public static int zzbg(int n) {
        return 4;
    }

    public static int zzbh(int n) {
        return 4;
    }

    public static int zzbb(long l) {
        return zzve.zzbc(l);
    }

    public static int zzbc(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzbd(long l) {
        return zzve.zzbc(zzve.zzbg(l));
    }

    public static int zzbe(long l) {
        return 8;
    }

    public static int zzbf(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzt(boolean bl) {
        return 1;
    }

    public static int zzbi(int n) {
        return zzve.zzbd(n);
    }

    public static int zzge(String string) {
        int n;
        try {
            n = zzyu.zza(string);
        }
        catch (zzyy zzyy2) {
            n = string.getBytes(zzvz.UTF_8).length;
        }
        int n2 = n;
        return zzve.zzbe(n2) + n2;
    }

    public static int zza(zzwl zzwl2) {
        int n = zzwl2.zzwe();
        return zzve.zzbe(n) + n;
    }

    public static int zzb(zzun zzun2) {
        int n = zzun2.size();
        return zzve.zzbe(n) + n;
    }

    public static int zzk(byte[] byArray) {
        int n = byArray.length;
        return zzve.zzbe(n) + n;
    }

    public static int zzc(zzxe zzxe2) {
        int n = zzxe2.zzwe();
        return zzve.zzbe(n) + n;
    }

    static int zzb(zzxe zzxe2, zzxu zzxu2) {
        zzxu zzxu3 = zzxu2;
        zzug zzug2 = (zzug)zzxe2;
        int n = zzug2.zzue();
        if (n == -1) {
            n = zzxu3.zzai(zzug2);
            zzug2.zzah(n);
        }
        int n2 = n;
        return zzve.zzbe(n2) + n2;
    }

    private static int zzbj(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzbg(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzvq();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzyy zzyy2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzyy2);
        byte[] byArray = string.getBytes(zzvz.UTF_8);
        try {
            this.zzaz(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzxe zzxe2, zzxu zzxu2) {
        zzxu zzxu3;
        int n2 = zzve.zzbc(n) << 1;
        zzxu zzxu4 = zzxu3 = zzxu2;
        zzug zzug2 = (zzug)zzxe2;
        int n3 = zzug2.zzue();
        if (n3 == -1) {
            n3 = zzxu4.zzai(zzug2);
            zzug2.zzah(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzxe zzxe2) {
        return zzxe2.zzwe();
    }

    @Deprecated
    public static int zzbk(int n) {
        return zzve.zzbe(n);
    }

    /* synthetic */ zzve(zzvf zzvf2) {
        this();
    }

    static final class zze
    extends zzve {
        private final ByteBuffer zzbvu;
        private final ByteBuffer zzbvv;
        private final long zzbvw;
        private final long zzbvx;
        private final long zzbvy;
        private final long zzbvz;
        private long zzbwa;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzbvu = byteBuffer;
            this.zzbvv = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzbvw = zzys.zzb(byteBuffer);
            this.zzbvx = this.zzbvw + (long)byteBuffer.position();
            this.zzbvy = this.zzbvw + (long)byteBuffer.limit();
            this.zzbvz = this.zzbvy - 10L;
            this.zzbwa = this.zzbvx;
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzve)this).zzaz(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzay(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzaz(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 5);
            ((zzve)this).zzbb(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzay(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzve)this).zzc(n, 1);
            ((zzve)this).zzba(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zzgd(string);
        }

        @Override
        public final void zza(int n, zzun zzun2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zza(zzun2);
        }

        @Override
        public final void zza(int n, zzxe zzxe2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zzb(zzxe2);
        }

        @Override
        final void zza(int n, zzxe zzxe2, zzxu zzxu2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zza(zzxe2, zzxu2);
        }

        @Override
        public final void zzb(int n, zzxe zzxe2) throws IOException {
            ((zzve)this).zzc(1, 3);
            ((zzve)this).zze(2, n);
            ((zzve)this).zza(3, zzxe2);
            ((zzve)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzun zzun2) throws IOException {
            ((zzve)this).zzc(1, 3);
            ((zzve)this).zze(2, n);
            ((zzve)this).zza(3, zzun2);
            ((zzve)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzxe zzxe2) throws IOException {
            ((zzve)this).zzaz(zzxe2.zzwe());
            zzxe2.zzb(this);
        }

        @Override
        final void zza(zzxe zzxe2, zzxu zzxu2) throws IOException {
            zzxu zzxu3 = zzxu2;
            zzug zzug2 = (zzug)zzxe2;
            int n = zzug2.zzue();
            if (n == -1) {
                n = zzxu3.zzai(zzug2);
                zzug2.zzah(n);
            }
            ((zzve)this).zzaz(n);
            zzxu2.zza(zzxe2, this.zzbvr);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zzbwa >= this.zzbvy) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbwa, this.zzbvy, 1));
            }
            zzys.zza(this.zzbwa++, by);
        }

        @Override
        public final void zza(zzun zzun2) throws IOException {
            ((zzve)this).zzaz(zzun2.size());
            zzun2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzve)this).zzaz(n2);
            ((zzve)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzay(int n) throws IOException {
            if (n >= 0) {
                ((zzve)this).zzaz(n);
                return;
            }
            ((zzve)this).zzay((long)n);
        }

        @Override
        public final void zzaz(int n) throws IOException {
            if (this.zzbwa <= this.zzbvz) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzys.zza(this.zzbwa++, (byte)n);
                        return;
                    }
                    zzys.zza(this.zzbwa++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzbwa < this.zzbvy) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzys.zza(this.zzbwa++, (byte)n);
                    return;
                }
                zzys.zza(this.zzbwa++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbwa, this.zzbvy, 1));
        }

        @Override
        public final void zzbb(int n) throws IOException {
            long l = this.zzbwa;
            zze zze2 = this;
            this.zzbvv.putInt((int)(l - zze2.zzbvw), n);
            this.zzbwa += 4L;
        }

        @Override
        public final void zzay(long l) throws IOException {
            if (this.zzbwa <= this.zzbvz) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzys.zza(this.zzbwa++, (byte)l);
                        return;
                    }
                    zzys.zza(this.zzbwa++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzbwa < this.zzbvy) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzys.zza(this.zzbwa++, (byte)l);
                    return;
                }
                zzys.zza(this.zzbwa++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbwa, this.zzbvy, 1));
        }

        @Override
        public final void zzba(long l) throws IOException {
            long l2 = this.zzbwa;
            zze zze2 = this;
            this.zzbvv.putLong((int)(l2 - zze2.zzbvw), l);
            this.zzbwa += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzbvy - (long)n2 < this.zzbwa) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbwa, this.zzbvy, n2));
            }
            zzys.zza(byArray, n, this.zzbwa, n2);
            this.zzbwa += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzve)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgd(String string) throws IOException {
            long l = this.zzbwa;
            try {
                int n = zze.zzbe(string.length() * 3);
                int n2 = zze.zzbe(string.length());
                if (n2 == n) {
                    long l2 = this.zzbwa;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzbvw) + n2;
                    this.zzbvv.position(n3);
                    zzyu.zza(string, this.zzbvv);
                    int n4 = this.zzbvv.position() - n3;
                    ((zzve)this).zzaz(n4);
                    this.zzbwa += (long)n4;
                    return;
                }
                int n5 = zzyu.zza(string);
                ((zzve)this).zzaz(n5);
                this.zzbh(this.zzbwa);
                zzyu.zza(string, this.zzbvv);
                this.zzbwa += (long)n5;
                return;
            }
            catch (zzyy zzyy2) {
                this.zzbwa = l;
                this.zzbh(this.zzbwa);
                this.zza(string, zzyy2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzbwa;
            zze zze2 = this;
            this.zzbvu.position((int)(l - zze2.zzbvw));
        }

        @Override
        public final int zzvq() {
            return (int)(this.zzbvy - this.zzbwa);
        }

        private final void zzbh(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzbvv.position((int)(l2 - zze2.zzbvw));
        }
    }

    static final class zzd
    extends zzve {
        private final ByteBuffer zzbvu;
        private final ByteBuffer zzbvv;
        private final int zzbvt;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzbvu = byteBuffer;
            this.zzbvv = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzbvt = byteBuffer.position();
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzve)this).zzaz(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzay(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzaz(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 5);
            ((zzve)this).zzbb(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzay(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzve)this).zzc(n, 1);
            ((zzve)this).zzba(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zzgd(string);
        }

        @Override
        public final void zza(int n, zzun zzun2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zza(zzun2);
        }

        @Override
        public final void zza(int n, zzxe zzxe2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zzb(zzxe2);
        }

        @Override
        final void zza(int n, zzxe zzxe2, zzxu zzxu2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zza(zzxe2, zzxu2);
        }

        @Override
        public final void zzb(int n, zzxe zzxe2) throws IOException {
            ((zzve)this).zzc(1, 3);
            ((zzve)this).zze(2, n);
            ((zzve)this).zza(3, zzxe2);
            ((zzve)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzun zzun2) throws IOException {
            ((zzve)this).zzc(1, 3);
            ((zzve)this).zze(2, n);
            ((zzve)this).zza(3, zzun2);
            ((zzve)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzxe zzxe2) throws IOException {
            ((zzve)this).zzaz(zzxe2.zzwe());
            zzxe2.zzb(this);
        }

        @Override
        final void zza(zzxe zzxe2, zzxu zzxu2) throws IOException {
            zzxu zzxu3 = zzxu2;
            zzug zzug2 = (zzug)zzxe2;
            int n = zzug2.zzue();
            if (n == -1) {
                n = zzxu3.zzai(zzug2);
                zzug2.zzah(n);
            }
            ((zzve)this).zzaz(n);
            zzxu2.zza(zzxe2, this.zzbvr);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzbvv.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzun zzun2) throws IOException {
            ((zzve)this).zzaz(zzun2.size());
            zzun2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzve)this).zzaz(n2);
            ((zzve)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzay(int n) throws IOException {
            if (n >= 0) {
                ((zzve)this).zzaz(n);
                return;
            }
            ((zzve)this).zzay((long)n);
        }

        @Override
        public final void zzaz(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzbvv.put((byte)n);
                        return;
                    }
                    this.zzbvv.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzbb(int n) throws IOException {
            try {
                this.zzbvv.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzay(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzbvv.put((byte)l);
                        return;
                    }
                    this.zzbvv.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzba(long l) throws IOException {
            try {
                this.zzbvv.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzbvv.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzve)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgd(String string) throws IOException {
            int n = this.zzbvv.position();
            try {
                int n2 = zzd.zzbe(string.length() * 3);
                int n3 = zzd.zzbe(string.length());
                if (n3 == n2) {
                    int n4 = this.zzbvv.position() + n3;
                    this.zzbvv.position(n4);
                    this.zzgf(string);
                    int n5 = this.zzbvv.position();
                    this.zzbvv.position(n);
                    ((zzve)this).zzaz(n5 - n4);
                    this.zzbvv.position(n5);
                    return;
                }
                int n6 = zzyu.zza(string);
                ((zzve)this).zzaz(n6);
                this.zzgf(string);
                return;
            }
            catch (zzyy zzyy2) {
                this.zzbvv.position(n);
                this.zza(string, zzyy2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzbvu.position(this.zzbvv.position());
        }

        @Override
        public final int zzvq() {
            return this.zzbvv.remaining();
        }

        private final void zzgf(String string) throws IOException {
            try {
                zzyu.zza(string, this.zzbvv);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzbvs;
        private int zzbvt;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzbvs = byteBuffer;
            this.zzbvt = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzbvs.position(this.zzbvt + this.zzvs());
        }
    }

    static class zza
    extends zzve {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzve)this).zzaz(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzay(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzaz(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zzve)this).zzc(n, 5);
            ((zzve)this).zzbb(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzay(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzve)this).zzc(n, 1);
            ((zzve)this).zzba(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzve)this).zzc(n, 0);
            ((zzve)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zzgd(string);
        }

        @Override
        public final void zza(int n, zzun zzun2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zza(zzun2);
        }

        @Override
        public final void zza(zzun zzun2) throws IOException {
            ((zzve)this).zzaz(zzun2.size());
            zzun2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzve)this).zzaz(n2);
            ((zzve)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzxe zzxe2) throws IOException {
            ((zzve)this).zzc(n, 2);
            ((zzve)this).zzb(zzxe2);
        }

        @Override
        final void zza(int n, zzxe zzxe2, zzxu zzxu2) throws IOException {
            ((zzve)this).zzc(n, 2);
            zzxu zzxu3 = zzxu2;
            zzug zzug2 = (zzug)zzxe2;
            int n2 = zzug2.zzue();
            if (n2 == -1) {
                n2 = zzxu3.zzai(zzug2);
                zzug2.zzah(n2);
            }
            ((zzve)this).zzaz(n2);
            zzxu2.zza(zzxe2, this.zzbvr);
        }

        @Override
        public final void zzb(int n, zzxe zzxe2) throws IOException {
            ((zzve)this).zzc(1, 3);
            ((zzve)this).zze(2, n);
            ((zzve)this).zza(3, zzxe2);
            ((zzve)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzun zzun2) throws IOException {
            ((zzve)this).zzc(1, 3);
            ((zzve)this).zze(2, n);
            ((zzve)this).zza(3, zzun2);
            ((zzve)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzxe zzxe2) throws IOException {
            ((zzve)this).zzaz(zzxe2.zzwe());
            zzxe2.zzb(this);
        }

        @Override
        final void zza(zzxe zzxe2, zzxu zzxu2) throws IOException {
            zzxu zzxu3 = zzxu2;
            zzug zzug2 = (zzug)zzxe2;
            int n = zzug2.zzue();
            if (n == -1) {
                n = zzxu3.zzai(zzug2);
                zzug2.zzah(n);
            }
            ((zzve)this).zzaz(n);
            zzxu2.zza(zzxe2, this.zzbvr);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzay(int n) throws IOException {
            if (n >= 0) {
                ((zzve)this).zzaz(n);
                return;
            }
            ((zzve)this).zzay((long)n);
        }

        @Override
        public final void zzaz(int n) throws IOException {
            if (zzbvq && ((zzve)this).zzvq() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzys.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzys.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzbb(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzay(long l) throws IOException {
            if (zzbvq && ((zzve)this).zzvq() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzys.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzys.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzba(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzve)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgd(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzbe(string.length() * 3);
                int n3 = zza.zzbe(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzyu.zza(string, this.buffer, this.position, ((zzve)this).zzvq());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzve)this).zzaz(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzyu.zza(string);
                ((zzve)this).zzaz(n6);
                this.position = zzyu.zza(string, this.buffer, this.position, ((zzve)this).zzvq());
                return;
            }
            catch (zzyy zzyy2) {
                this.position = n;
                this.zza(string, zzyy2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzvq() {
            return this.limit - this.position;
        }

        public final int zzvs() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

