/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;

public final class zzgd
extends zzcu {
    private static final String[] zztb = new String[]{"firebase_", "google_", "ga_"};
    private SecureRandom zztc;
    private final AtomicLong zztd = new AtomicLong(0L);
    private int zzae;
    private Integer zzte = null;

    zzgd(zzby zzby2) {
        super(zzby2);
    }

    @Override
    protected final boolean zzak() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzal() {
        ((zzct)this).zzq();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzct)this).zzad().zzdd().zzaq("Utils falling back to Random for random id");
        }
        this.zztd.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzgk() {
        if (this.zztd.get() == 0L) {
            AtomicLong atomicLong = this.zztd;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzct)this).zzz().currentTimeMillis()).nextLong() + (long)(++this.zzae);
            }
        }
        AtomicLong atomicLong = this.zztd;
        synchronized (atomicLong) {
            this.zztd.compareAndSet(-1L, 1L);
            return this.zztd.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzgl() {
        ((zzct)this).zzq();
        if (this.zztc == null) {
            this.zztc = new SecureRandom();
        }
        return this.zztc;
    }

    static boolean zzbm(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    final Bundle zza(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzct)this).zzad().zzdd().zza("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    static boolean zzc(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    final boolean zzp(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzct)this).zzad().zzda().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzct)this).zzad().zzda().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzct)this).zzad().zzda().zza("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzct)this).zzad().zzda().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    private final boolean zzq(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzct)this).zzad().zzda().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzct)this).zzad().zzda().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzct)this).zzad().zzda().zza("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzct)this).zzad().zzda().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String string2) {
        boolean bl;
        int n;
        String[] stringArray2;
        String string3;
        block6: {
            if (string2 == null) {
                ((zzct)this).zzad().zzda().zza("Name is required and can't be null. Type", string);
                return false;
            }
            string3 = string2;
            Preconditions.checkNotNull((Object)string3);
            stringArray2 = zztb;
            int n2 = zztb.length;
            for (n = 0; n < n2; ++n) {
                String string4 = stringArray2[n];
                if (!string3.startsWith(string4)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            ((zzct)this).zzad().zzda().zza("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null) {
            boolean bl2;
            block7: {
                stringArray2 = stringArray;
                string3 = string2;
                Preconditions.checkNotNull((Object)stringArray2);
                String[] stringArray3 = stringArray2;
                n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string5 = stringArray3[i];
                    if (!zzgd.zzs(string3, string5)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                ((zzct)this).zzad().zzda().zza("Name is reserved. Type, name", string, string2);
                return false;
            }
        }
        return true;
    }

    final boolean zza(String string, int n, String string2) {
        if (string2 == null) {
            ((zzct)this).zzad().zzda().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzct)this).zzad().zzda().zza("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final int zzbn(String string) {
        if (!this.zzq("event", string)) {
            return 2;
        }
        if (!this.zza("event", zzcx.zzoy, string)) {
            return 13;
        }
        if (!this.zza("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzbo(String string) {
        if (!this.zzq("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", zzcz.zzpc, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    private final boolean zza(String string, String string2, int n, Object object, boolean bl) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzct)this).zzad().zzdd().zza("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        if (object instanceof Bundle && bl) {
            return true;
        }
        if (object instanceof Parcelable[] && bl) {
            for (Parcelable parcelable : (Parcelable[])object) {
                if (parcelable instanceof Bundle) continue;
                ((zzct)this).zzad().zzdd().zza("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                return false;
            }
            return true;
        }
        if (object instanceof ArrayList && bl) {
            ArrayList arrayList = (ArrayList)object;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList.get(i);
                Object e2 = e;
                if (e instanceof Bundle) continue;
                ((zzct)this).zzad().zzdd().zza("All ArrayList elements must be of type Bundle. Value type, name", e2.getClass(), string2);
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzr(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!zzgd.zzbp(string)) {
                if (this.zzl.zzel()) {
                    ((zzct)this).zzad().zzda().zza("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzau.zzao(string));
                }
                return false;
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (!zzgd.zzbp(string2)) {
                ((zzct)this).zzad().zzda().zza("Invalid admob_app_id. Analytics disabled.", zzau.zzao(string2));
                return false;
            }
        } else {
            if (this.zzl.zzel()) {
                ((zzct)this).zzad().zzda().zzaq("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            }
            return false;
        }
        return true;
    }

    static boolean zza(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl && bl2) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    @VisibleForTesting
    private static boolean zzbp(String string) {
        Preconditions.checkNotNull((Object)string);
        String string2 = "^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$";
        return string.matches(string2);
    }

    private static Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzgd.zza(String.valueOf(object), n, bl);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    final Object zzb(String string, Object object) {
        if ("_ev".equals(string)) {
            return zzgd.zza(256, object, true);
        }
        return zzgd.zza(zzgd.zzbs(string) ? 256 : 100, object, false);
    }

    static Bundle[] zzb(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    final Bundle zza(String var1_1, String var2_2, Bundle var3_3, @Nullable List<String> var4_4, boolean var5_5, boolean var6_6) {
        block15: {
            var7_7 = null;
            if (var3_3 == null) break block15;
            var7_7 = new Bundle(var3_3);
            var8_8 = 0;
            var9_9 = this.zzaf().zze(var1_1, zzal.zziy) != false ? new TreeSet<E>(var3_3.keySet()) : var3_3.keySet();
            for (String var11_11 : var9_9) {
                block16: {
                    var12_12 = 0;
                    if (var4_4 == null || !var4_4.contains(var11_11)) {
                        if (var5_5) {
                            var14_14 = this;
                            var15_15 = var11_11;
                            v0 = var14_14.zzp("event param", var15_15) == false ? 3 : (var14_14.zza("event param", null, var15_15) == false ? 14 : (var12_12 = var14_14.zza("event param", 40, var15_15) == false ? 3 : 0));
                        }
                        if (var12_12 == 0) {
                            var14_14 = this;
                            var15_15 = var11_11;
                            v1 = var14_14.zzq("event param", var15_15) == false ? 3 : (var14_14.zza("event param", null, var15_15) == false ? 14 : (var12_12 = var14_14.zza("event param", 40, var15_15) == false ? 3 : 0));
                        }
                    }
                    if (var12_12 != 0) {
                        if (zzgd.zza(var7_7, var12_12)) {
                            var13_13 = zzgd.zza(var11_11, 40, true);
                            var7_7.putString("_ev", var13_13);
                            if (var12_12 == 3) {
                                zzgd.zzb(var7_7, (Object)var11_11);
                            }
                        }
                        var7_7.remove(var11_11);
                        continue;
                    }
                    var19_19 = var6_6;
                    var18_18 = var3_3.get(var11_11);
                    var17_17 = var11_11;
                    var16_16 = var2_2;
                    var15_15 = var1_1;
                    var14_14 = this;
                    var14_14.zzq();
                    if (!var19_19) ** GOTO lbl-1000
                    var24_24 = var18_18;
                    var23_23 = var17_17;
                    var22_22 = "param";
                    var21_21 = var14_14;
                    if (!(var24_24 instanceof Parcelable[])) break block16;
                    var25_25 = ((Parcelable[])var24_24).length;
                    ** GOTO lbl45
                }
                if (!(var24_24 instanceof ArrayList)) {
                    v2 = true;
                } else {
                    var25_25 = ((ArrayList)var24_24).size();
lbl45:
                    // 2 sources

                    if (var25_25 > 1000) {
                        var21_21.zzad().zzdd().zza("Parameter array is too long; discarded. Value kind, name, array length", var22_22, var23_23, var25_25);
                        v2 = false;
                    } else {
                        v2 = true;
                    }
                }
                if (!v2) {
                    v3 = 17;
                } else lbl-1000:
                // 2 sources

                {
                    var20_20 = var14_14.zzaf().zzn(var15_15) != false && zzgd.zzbs(var16_16) != false || zzgd.zzbs(var17_17) != false ? var14_14.zza("param", var17_17, 256, var18_18, var19_19) : var14_14.zza("param", var17_17, 100, var18_18, var19_19);
                    v3 = var12_12 = var20_20 != false ? 0 : 4;
                }
                if (v3 != 0 && !"_ev".equals(var11_11)) {
                    if (zzgd.zza(var7_7, var12_12)) {
                        var13_13 = zzgd.zza(var11_11, 40, true);
                        var7_7.putString("_ev", var13_13);
                        zzgd.zzb(var7_7, var3_3.get(var11_11));
                    }
                    var7_7.remove(var11_11);
                    continue;
                }
                if (!zzgd.zzbm(var11_11) || ++var8_8 <= 25) continue;
                var13_13 = new StringBuilder(48).append("Event can't contain more than 25 params").toString();
                this.zzad().zzda().zza(var13_13, this.zzaa().zzal(var2_2), this.zzaa().zzc(var3_3));
                zzgd.zza(var7_7, 5);
                var7_7.remove(var11_11);
            }
        }
        return var7_7;
    }

    private static boolean zza(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private static void zzb(Bundle bundle, Object object) {
        Preconditions.checkNotNull((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private static int zzbq(String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        return 36;
    }

    final int zzc(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, zzgd.zzbq(string), object, false) : this.zza("user property", string, zzgd.zzbq(string), object, false);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzd(String string, Object object) {
        if ("_ldl".equals(string)) {
            return zzgd.zza(zzgd.zzbq(string), object, true);
        }
        return zzgd.zza(zzgd.zzbq(string), object, false);
    }

    final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzct)this).zzad().zzdf().zza("Not putting event parameter. Invalid value type. name, type", ((zzct)this).zzaa().zzam(string), string3);
        }
    }

    public final void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    final void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzgd.zza(bundle, n);
        if (((zzct)this).zzaf().zze(string, zzal.zzis)) {
            if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString(string2, string3);
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zzq zzq2 = this.zzl.zzag();
        this.zzl.zzs().logEvent("auto", "_err", bundle);
    }

    static MessageDigest getMessageDigest() {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    @VisibleForTesting
    static long zzd(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    static boolean zzb(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzgd.zzb(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzgd.zzb(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    private static boolean zzb(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    final boolean zzbr(String string) {
        ((zzct)this).zzq();
        if (Wrappers.packageManager((Context)((zzct)this).getContext()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzct)this).zzad().zzdh().zza("Permission not granted", string);
        return false;
    }

    static boolean zzbs(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzs(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    static boolean zza(Boolean bl, Boolean bl2) {
        if (bl == null && bl2 == null) {
            return true;
        }
        if (bl == null) {
            return false;
        }
        return bl.equals(bl2);
    }

    final boolean zzbt(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = ((zzct)this).zzaf().zzbu();
        zzq zzq2 = ((zzct)this).zzag();
        return string2.equals(string);
    }

    final Bundle zzg(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzb(string, bundle.get(string));
                if (object == null) {
                    ((zzct)this).zzad().zzdd().zza("Param value can't be null", ((zzct)this).zzaa().zzam(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    final zzaj zza(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (this.zzbn(string2) != 0) {
            ((zzct)this).zzad().zzda().zza("Invalid conditional property event name", ((zzct)this).zzaa().zzan(string2));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        List list = CollectionUtils.listOf((Object)"_o");
        Bundle bundle2 = this.zza(string, string2, bundle, list, false, false);
        Bundle bundle3 = this.zzg(bundle2);
        return new zzaj(string2, new zzag(bundle3), string3, l);
    }

    @WorkerThread
    final long zzc(Context context, String string) {
        ((zzct)this).zzq();
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzgd.getMessageDigest();
        if (messageDigest == null) {
            ((zzct)this).zzad().zzda().zzaq("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzd(context, string)) {
                    PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(((zzct)this).getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzgd.zzd(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzct)this).zzad().zzdd().zzaq("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzct)this).zzad().zzda().zza("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    @VisibleForTesting
    private final boolean zzd(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzct)this).zzad().zzda().zza("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzct)this).zzad().zzda().zza("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Bundle zzh(Bundle bundle) {
        if (bundle == null) {
            return new Bundle();
        }
        Bundle bundle2 = new Bundle(bundle);
        for (String string : bundle2.keySet()) {
            int n;
            Object object;
            Object object2 = bundle2.get(string);
            if (object2 instanceof Bundle) {
                bundle2.putBundle(string, new Bundle((Bundle)object2));
                continue;
            }
            if (object2 instanceof Parcelable[]) {
                object = (Parcelable[])object2;
                for (n = 0; n < ((Parcelable[])object).length; ++n) {
                    if (!(object[n] instanceof Bundle)) continue;
                    object[n] = new Bundle((Bundle)object[n]);
                }
                continue;
            }
            if (!(object2 instanceof List)) continue;
            object = (List)object2;
            for (n = 0; n < object.size(); ++n) {
                Object e = object.get(n);
                if (!(e instanceof Bundle)) continue;
                object.set(n, new Bundle((Bundle)e));
            }
        }
        return bundle2;
    }

    public final int zzgm() {
        if (this.zzte == null) {
            this.zzte = GoogleApiAvailabilityLight.getInstance().getApkVersion(((zzct)this).getContext()) / 1000;
        }
        return this.zzte;
    }

    public final int zzd(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzct)this).getContext(), 12451000);
    }

    public static long zzc(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    @WorkerThread
    final String zzgn() {
        byte[] byArray = new byte[16];
        this.zzgl().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    final void zzb(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            ((zzct)this).zzad().zzdd().zza("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    public final void zzb(com.google.android.gms.internal.measurement.zzq zzq2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.internal.measurement.zzq zzq2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.internal.measurement.zzq zzq2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.internal.measurement.zzq zzq2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.internal.measurement.zzq zzq2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.internal.measurement.zzq zzq2, Bundle bundle) {
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public static Bundle zzb(List<zzga> list) {
        Bundle bundle = new Bundle();
        if (list == null) {
            return bundle;
        }
        for (zzga zzga2 : list) {
            if (zzga2.zzki != null) {
                bundle.putString(zzga2.name, zzga2.zzki);
                continue;
            }
            if (zzga2.zzsy != null) {
                bundle.putLong(zzga2.name, zzga2.zzsy.longValue());
                continue;
            }
            if (zzga2.zzta == null) continue;
            bundle.putDouble(zzga2.name, zzga2.zzta.doubleValue());
        }
        return bundle;
    }

    public final void zza(com.google.android.gms.internal.measurement.zzq zzq2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public static ArrayList<Bundle> zzc(List<zzr> list) {
        if (list == null) {
            return new ArrayList<Bundle>(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(list.size());
        for (zzr zzr2 : list) {
            Bundle bundle = new Bundle();
            bundle.putString("app_id", zzr2.packageName);
            bundle.putString("origin", zzr2.origin);
            bundle.putLong("creation_timestamp", zzr2.creationTimestamp);
            bundle.putString("name", zzr2.zzdv.name);
            zzcw.zza((Bundle)bundle, (Object)zzr2.zzdv.getValue());
            bundle.putBoolean("active", zzr2.active);
            if (zzr2.triggerEventName != null) {
                bundle.putString("trigger_event_name", zzr2.triggerEventName);
            }
            if (zzr2.zzdw != null) {
                bundle.putString("timed_out_event_name", zzr2.zzdw.name);
                if (zzr2.zzdw.zzfd != null) {
                    bundle.putBundle("timed_out_event_params", zzr2.zzdw.zzfd.zzct());
                }
            }
            bundle.putLong("trigger_timeout", zzr2.triggerTimeout);
            if (zzr2.zzdx != null) {
                bundle.putString("triggered_event_name", zzr2.zzdx.name);
                if (zzr2.zzdx.zzfd != null) {
                    bundle.putBundle("triggered_event_params", zzr2.zzdx.zzfd.zzct());
                }
            }
            bundle.putLong("triggered_timestamp", zzr2.zzdv.zzsx);
            bundle.putLong("time_to_live", zzr2.timeToLive);
            if (zzr2.zzdy != null) {
                bundle.putString("expired_event_name", zzr2.zzdy.name);
                if (zzr2.zzdy.zzfd != null) {
                    bundle.putBundle("expired_event_params", zzr2.zzdy.zzfd.zzct());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }
}

