/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzgu;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfa
extends zzdj<Integer>
implements zzfd,
zzgu,
RandomAccess {
    private static final zzfa zzaiu = new zzfa(new int[0], 0);
    private int[] zzaiv;
    private int size;

    public static zzfa zzus() {
        return zzaiu;
    }

    zzfa() {
        this(new int[10], 0);
    }

    private zzfa(int[] nArray, int n) {
        this.zzaiv = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzrz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaiv, n2, this.zzaiv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfa)) {
            return super.equals(object);
        }
        zzfa zzfa2 = (zzfa)object;
        if (this.size != zzfa2.size) {
            return false;
        }
        int[] nArray = zzfa2.zzaiv;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzaiv[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzaiv[i];
        }
        return n;
    }

    @Override
    public final zzfd zzbt(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzfa(Arrays.copyOf(this.zzaiv, n), this.size);
    }

    public final int getInt(int n) {
        this.zzan(n);
        return this.zzaiv[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbu(int n) {
        this.zzo(this.size, n);
    }

    private final void zzo(int n, int n2) {
        this.zzrz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
        if (this.size < this.zzaiv.length) {
            System.arraycopy(this.zzaiv, n, this.zzaiv, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaiv, 0, nArray, 0, n);
            System.arraycopy(this.zzaiv, n, nArray, n + 1, this.size - n);
            this.zzaiv = nArray;
        }
        this.zzaiv[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzrz();
        zzez.checkNotNull(collection);
        if (!(collection instanceof zzfa)) {
            return super.addAll(collection);
        }
        zzfa zzfa2 = (zzfa)collection;
        if (zzfa2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfa2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfa2.size;
        if (n > this.zzaiv.length) {
            this.zzaiv = Arrays.copyOf(this.zzaiv, n);
        }
        System.arraycopy(zzfa2.zzaiv, 0, this.zzaiv, this.size, zzfa2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzrz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaiv[i])) continue;
            System.arraycopy(this.zzaiv, i + 1, this.zzaiv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzan(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
    }

    private final String zzao(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfa zzfa2 = this;
        zzfa2.zzrz();
        zzfa2.zzan(n);
        int n4 = zzfa2.zzaiv[n];
        zzfa2.zzaiv[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfa zzfa2 = this;
        zzfa2.zzrz();
        zzfa2.zzan(n);
        int n2 = zzfa2.zzaiv[n];
        if (n < zzfa2.size - 1) {
            System.arraycopy(zzfa2.zzaiv, n + 1, zzfa2.zzaiv, n, zzfa2.size - n - 1);
        }
        --zzfa2.size;
        ++zzfa2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzo(n, n2);
    }

    @Override
    public final /* synthetic */ zzff zzap(int n) {
        return this.zzbt(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzaiu.zzry();
    }
}

