/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzjs;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzeo
extends zzge {
    @VisibleForTesting
    static final Pair<String, Long> zzlg = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzlh;
    public zzes zzli;
    public final zzet zzlj = new zzet(this, "last_upload", 0L);
    public final zzet zzlk = new zzet(this, "last_upload_attempt", 0L);
    public final zzet zzll = new zzet(this, "backoff", 0L);
    public final zzet zzlm = new zzet(this, "last_delete_stale", 0L);
    public final zzet zzln;
    public final zzet zzlo;
    public final zzet zzlp;
    public final zzev zzlq;
    private String zzlr;
    private boolean zzls;
    private long zzlt;
    public final zzet zzlu = new zzet(this, "time_before_start", 10000L);
    public final zzet zzlv = new zzet(this, "session_timeout", 1800000L);
    public final zzeq zzlw = new zzeq(this, "start_new_session", true);
    public final zzev zzlx;
    public final zzeq zzly;
    public final zzeq zzlz;
    public final zzet zzma = new zzet(this, "last_pause_time", 0L);
    public final zzet zzmb = new zzet(this, "time_active", 0L);
    public boolean zzmc;
    public zzeq zzmd;
    public zzet zzme;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzap(String string) {
        this.zzo();
        long l = this.zzx().elapsedRealtime();
        if (this.zzlr != null && l < this.zzlt) {
            return new Pair((Object)this.zzlr, (Object)this.zzls);
        }
        String string2 = string;
        this.zzlt = l + this.zzad().zza(string2, zzak.zzgg);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzlr = info.getId();
                this.zzls = info.isLimitAdTrackingEnabled();
            }
            if (this.zzlr == null) {
                this.zzlr = "";
            }
        }
        catch (Exception exception) {
            this.zzab().zzgr().zza("Unable to get advertising id", exception);
            this.zzlr = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzlr, (Object)this.zzls);
    }

    @WorkerThread
    final String zzaq(String string) {
        this.zzo();
        String string2 = (String)this.zzap((String)string).first;
        MessageDigest messageDigest = zzjs.getMessageDigest();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzeo(zzfj zzfj2) {
        super(zzfj2);
        this.zzlx = new zzev(this, "non_personalized_ads", null);
        this.zzly = new zzeq(this, "use_dynamite_api", false);
        this.zzlz = new zzeq(this, "allow_remote_dynamite", false);
        this.zzln = new zzet(this, "midnight_offset", 0L);
        this.zzlo = new zzet(this, "first_open_time", 0L);
        this.zzlp = new zzet(this, "app_install_time", 0L);
        this.zzlq = new zzev(this, "app_instance_id", null);
        this.zzmd = new zzeq(this, "app_backgrounded", false);
        this.zzme = new zzet(this, "deep_link_last_retrieved", -1L);
    }

    @Override
    protected final boolean zzbk() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzbl() {
        this.zzlh = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzmc = this.zzlh.getBoolean("has_been_opened", false);
        if (!this.zzmc) {
            SharedPreferences.Editor editor = this.zzlh.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzli = new zzes(this, "health_monitor", Math.max(0L, (Long)zzak.zzgh.get(null)), null);
    }

    @WorkerThread
    private final SharedPreferences zzhb() {
        this.zzo();
        this.zzbi();
        return this.zzlh;
    }

    @WorkerThread
    final void zzar(String string) {
        this.zzo();
        SharedPreferences.Editor editor = this.zzhb().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzhc() {
        this.zzo();
        return this.zzhb().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzas(String string) {
        this.zzo();
        SharedPreferences.Editor editor = this.zzhb().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzhd() {
        this.zzo();
        return this.zzhb().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzhe() {
        this.zzo();
        if (!this.zzhb().contains("use_service")) {
            return null;
        }
        return this.zzhb().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzd(boolean bl) {
        this.zzo();
        this.zzab().zzgs().zza("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzhb().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzhf() {
        this.zzo();
        this.zzab().zzgs().zzao("Clearing collection preferences.");
        if (this.zzad().zza(zzak.zzil)) {
            Boolean bl = this.zzhg();
            SharedPreferences.Editor editor = this.zzhb().edit();
            editor.clear();
            editor.apply();
            if (bl != null) {
                this.setMeasurementEnabled(bl);
            }
            return;
        }
        boolean bl = this.zzhb().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zze(true);
        }
        SharedPreferences.Editor editor = this.zzhb().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzo();
        this.zzab().zzgs().zza("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzhb().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zze(boolean bl) {
        this.zzo();
        return this.zzhb().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    final Boolean zzhg() {
        this.zzo();
        if (this.zzhb().contains("measurement_enabled")) {
            return this.zzhb().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzhh() {
        this.zzo();
        String string = this.zzhb().getString("previous_os_version", null);
        this.zzw().zzbi();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzhb().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzf(boolean bl) {
        this.zzo();
        this.zzab().zzgs().zza("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzhb().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzhi() {
        this.zzo();
        return this.zzhb().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzhj() {
        return this.zzlh.contains("deferred_analytics_collection");
    }

    final boolean zzx(long l) {
        return l - this.zzlv.get() > this.zzma.get();
    }

    static /* synthetic */ SharedPreferences zza(zzeo zzeo2) {
        return zzeo2.zzhb();
    }
}

