/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzf;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgf;
import java.util.List;

public final class zzeu {
    final zzfj zzj;

    zzeu(zzfj zzfj2) {
        this.zzj = zzfj2;
    }

    @WorkerThread
    protected final void zzat(String string) {
        if (string == null || string.isEmpty()) {
            this.zzj.zzab().zzgq().zzao("Install Referrer Reporter was called with invalid app package name");
            return;
        }
        ((zzgf)this.zzj.zzaa()).zzo();
        if (!this.zzhn()) {
            this.zzj.zzab().zzgq().zzao("Install Referrer Reporter is not available");
            return;
        }
        this.zzj.zzab().zzgq().zzao("Install Referrer Reporter is initializing");
        zzex zzex2 = new zzex(this, string);
        zzeu zzeu2 = this;
        ((zzgf)zzeu2.zzj.zzaa()).zzo();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzeu2.zzj.getContext().getPackageManager();
        if (packageManager == null) {
            zzeu2.zzj.zzab().zzgn().zzao("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string2 = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && "com.android.vending".equals(string2) && zzeu2.zzhn()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzeu2.zzj.getContext(), intent2, (ServiceConnection)zzex2, 1);
                        zzeu2.zzj.zzab().zzgq().zza("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzeu2.zzj.zzab().zzgk().zza("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzeu2.zzj.zzab().zzgq().zzao("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzeu2.zzj.zzab().zzgq().zzao("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzhn() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzj.getContext());
            if (packageManagerWrapper == null) {
                this.zzj.zzab().zzgq().zzao("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzj.zzab().zzgq().zza("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zza(String string, zzf zzf2) {
        Bundle bundle;
        ((zzgf)this.zzj.zzaa()).zzo();
        if (zzf2 == null) {
            this.zzj.zzab().zzgn().zzao("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", string);
        try {
            bundle = zzf2.zza(bundle2);
            if (bundle == null) {
                this.zzj.zzab().zzgk().zzao("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzj.zzab().zzgk().zza("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }
}

