/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzhv
extends zzg {
    private final zzin zzre;
    private zzdx zzrf;
    private volatile Boolean zzrg;
    private final zzaa zzrh;
    private final zzjd zzri;
    private final List<Runnable> zzrj = new ArrayList<Runnable>();
    private final zzaa zzrk;

    protected zzhv(zzfj zzfj2) {
        super(zzfj2);
        this.zzri = new zzjd(zzfj2.zzx());
        this.zzre = new zzin(this);
        this.zzrh = new zzhu(this, zzfj2);
        this.zzrk = new zzif(this, zzfj2);
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzgf)this).zzo();
        this.zzbi();
        return this.zzrf != null;
    }

    @WorkerThread
    protected final void zzip() {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(true);
        this.zzd(new zzie(this, zzn2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzdx zzdx2, AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzgf)this).zzo();
        ((zzgf)this).zzm();
        this.zzbi();
        boolean bl = this.zziq();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzd)this).zzu().zzc(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzai) {
                    try {
                        zzdx2.zza((zzai)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgf)this).zzab().zzgk().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzjn) {
                    try {
                        zzdx2.zza((zzjn)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgf)this).zzab().zzgk().zza("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzq) {
                    try {
                        zzdx2.zza((zzq)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgf)this).zzab().zzgk().zza("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzgf)this).zzab().zzgk().zzao("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzai zzai2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzai2));
        ((zzgf)this).zzo();
        this.zzbi();
        boolean bl = this.zziq();
        boolean bl2 = bl && ((zzd)this).zzu().zza(zzai2);
        zzn zzn2 = this.zzi(true);
        this.zzd(new zzih(this, bl, bl2, zzai2, zzn2, string));
    }

    @WorkerThread
    protected final void zzd(zzq zzq2) {
        Preconditions.checkNotNull((Object)((Object)zzq2));
        ((zzgf)this).zzo();
        this.zzbi();
        zzr zzr2 = ((zzgf)this).zzae();
        boolean bl = true;
        boolean bl2 = true && ((zzd)this).zzu().zzc(zzq2);
        zzq zzq3 = new zzq(zzq2);
        zzn zzn2 = this.zzi(true);
        this.zzd(new zzig(this, bl, bl2, zzq3, zzn2, zzq2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzq>> atomicReference, String string, String string2, String string3) {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        this.zzd(new zzij(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(zzp zzp2, String string, String string2) {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        this.zzd(new zzii(this, string, string2, zzn2, zzp2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjn>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        this.zzd(new zzil(this, atomicReference, string, string2, string3, bl, zzn2));
    }

    @WorkerThread
    protected final void zza(zzp zzp2, String string, String string2, boolean bl) {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        this.zzd(new zzik(this, string, string2, bl, zzn2, zzp2));
    }

    @WorkerThread
    protected final void zzb(zzjn zzjn2) {
        ((zzgf)this).zzo();
        this.zzbi();
        boolean bl = this.zziq() && ((zzd)this).zzu().zza(zzjn2);
        zzn zzn2 = this.zzi(true);
        this.zzd(new zzhx(this, bl, zzjn2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzjn>> atomicReference, boolean bl) {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        this.zzd(new zzhw(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzgf)this).zzo();
        ((zzgf)this).zzm();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        if (this.zziq()) {
            ((zzd)this).zzu().resetAnalyticsData();
        }
        this.zzd(new zzhz(this, zzn2));
    }

    private final boolean zziq() {
        zzr zzr2 = ((zzgf)this).zzae();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        this.zzd(new zzhy(this, atomicReference, zzn2));
    }

    @WorkerThread
    public final void getAppInstanceId(zzp zzp2) {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(false);
        this.zzd(new zzib(this, zzn2, zzp2));
    }

    @WorkerThread
    protected final void zzim() {
        ((zzgf)this).zzo();
        this.zzbi();
        zzn zzn2 = this.zzi(true);
        boolean bl = ((zzgf)this).zzad().zza(zzak.zzjd);
        if (bl) {
            ((zzd)this).zzu().zzgh();
        }
        this.zzd(new zzia(this, zzn2, bl));
    }

    @WorkerThread
    protected final void zza(zzhr zzhr2) {
        ((zzgf)this).zzo();
        this.zzbi();
        this.zzd(new zzid(this, zzhr2));
    }

    @WorkerThread
    private final void zzir() {
        ((zzgf)this).zzo();
        this.zzri.start();
        this.zzrh.zzv((Long)zzak.zzhl.get(null));
    }

    @WorkerThread
    final void zzis() {
        zzr zzr2;
        Boolean bl;
        zzhv zzhv2;
        ((zzgf)this).zzo();
        this.zzbi();
        if (this.isConnected()) {
            return;
        }
        if (this.zzrg == null) {
            boolean bl2;
            zzhv2 = this;
            ((zzgf)zzhv2).zzo();
            zzhv2.zzbi();
            bl = ((zzgf)zzhv2).zzac().zzhe();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzr2 = ((zzgf)zzhv2).zzae();
                if (((zzd)zzhv2).zzr().zzgg() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzgf)zzhv2).zzab().zzgs().zzao("Checking service availability");
                    int n = ((zzgf)zzhv2).zzz().zzd(12451000);
                    switch (n) {
                        case 0: {
                            ((zzgf)zzhv2).zzab().zzgs().zzao("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzgf)zzhv2).zzab().zzgs().zzao("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzgf)zzhv2).zzab().zzgn().zzao("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzgf)zzhv2).zzab().zzgr().zzao("Service container out of date");
                            if (((zzgf)zzhv2).zzz().zzjx() < 15300) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzgf)zzhv2).zzac().zzhe();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzgf)zzhv2).zzab().zzgn().zzao("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzgf)zzhv2).zzab().zzgn().zzao("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzgf)zzhv2).zzab().zzgn().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzgf)zzhv2).zzad().zzbw()) {
                    ((zzgf)zzhv2).zzab().zzgk().zzao("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzgf)zzhv2).zzac().zzd(bl4);
                }
                bl2 = bl4;
            }
            this.zzrg = bl2;
        }
        if (this.zzrg.booleanValue()) {
            this.zzre.zzix();
            return;
        }
        if (!((zzgf)this).zzad().zzbw()) {
            Intent intent;
            zzhv2 = this;
            zzr2 = ((zzgf)zzhv2).zzae();
            bl = ((zzgf)zzhv2).getContext().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzgf)zzhv2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzr2 = ((zzgf)this).zzae();
                intent2.setComponent(new ComponentName(((zzgf)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzre.zzb(intent2);
                return;
            }
            ((zzgf)this).zzab().zzgk().zzao("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzit() {
        return this.zzrg;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzdx zzdx2) {
        ((zzgf)this).zzo();
        Preconditions.checkNotNull((Object)zzdx2);
        this.zzrf = zzdx2;
        this.zzir();
        this.zziv();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzgf)this).zzo();
        this.zzbi();
        this.zzre.zziw();
        try {
            ConnectionTracker.getInstance().unbindService(((zzgf)this).getContext(), (ServiceConnection)this.zzre);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzrf = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzgf)this).zzo();
        if (this.zzrf != null) {
            this.zzrf = null;
            ((zzgf)this).zzab().zzgs().zza("Disconnected from device MeasurementService", componentName);
            zzhv zzhv2 = this;
            ((zzgf)zzhv2).zzo();
            zzhv2.zzis();
        }
    }

    @WorkerThread
    private final void zziu() {
        ((zzgf)this).zzo();
        if (!this.isConnected()) {
            return;
        }
        ((zzgf)this).zzab().zzgs().zzao("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzd(Runnable runnable) throws IllegalStateException {
        ((zzgf)this).zzo();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzrj.size() >= 1000L) {
            ((zzgf)this).zzab().zzgk().zzao("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzrj.add(runnable);
        this.zzrk.zzv(60000L);
        this.zzis();
    }

    @WorkerThread
    private final void zziv() {
        ((zzgf)this).zzo();
        ((zzgf)this).zzab().zzgs().zza("Processing queued up service tasks", this.zzrj.size());
        for (Runnable runnable : this.zzrj) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzgf)this).zzab().zzgk().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzrj.clear();
        this.zzrk.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzn zzi(boolean bl) {
        zzr zzr2 = ((zzgf)this).zzae();
        return ((zzd)this).zzr().zzai(bl ? ((zzgf)this).zzab().zzgu() : null);
    }

    @WorkerThread
    public final void zza(zzp zzp2, zzai zzai2, String string) {
        ((zzgf)this).zzo();
        this.zzbi();
        int n = ((zzgf)this).zzz().zzd(12451000);
        if (n != 0) {
            ((zzgf)this).zzab().zzgn().zzao("Not bundling data. Service unavailable or out of date");
            ((zzgf)this).zzz().zza(zzp2, new byte[0]);
            return;
        }
        this.zzd(new zzic(this, zzai2, string, zzp2));
    }

    static /* synthetic */ zzin zza(zzhv zzhv2) {
        return zzhv2.zzre;
    }

    static /* synthetic */ void zza(zzhv zzhv2, ComponentName componentName) {
        zzhv2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzdx zza(zzhv zzhv2, zzdx zzdx2) {
        zzhv2.zzrf = null;
        return null;
    }

    static /* synthetic */ void zzb(zzhv zzhv2) {
        zzhv2.zziv();
    }

    static /* synthetic */ void zzc(zzhv zzhv2) {
        zzhv2.zziu();
    }

    static /* synthetic */ zzdx zzd(zzhv zzhv2) {
        return zzhv2.zzrf;
    }

    static /* synthetic */ void zze(zzhv zzhv2) {
        zzhv2.zzir();
    }
}

