/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzjy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzeu
extends zzgk {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzx;
    public zzey zzb;
    public final zzev zzc = new zzev(this, "last_upload", 0L);
    public final zzev zzd = new zzev(this, "last_upload_attempt", 0L);
    public final zzev zze = new zzev(this, "backoff", 0L);
    public final zzev zzf = new zzev(this, "last_delete_stale", 0L);
    public final zzev zzg;
    public final zzev zzh;
    public final zzev zzi;
    public final zzex zzj;
    private String zzy;
    private boolean zzz;
    private long zzaa;
    public final zzev zzk = new zzev(this, "time_before_start", 10000L);
    public final zzev zzl = new zzev(this, "session_timeout", 1800000L);
    public final zzew zzm = new zzew(this, "start_new_session", true);
    public final zzex zzn;
    public final zzew zzo;
    public final zzew zzp;
    public final zzev zzq = new zzev(this, "last_pause_time", 0L);
    public final zzev zzr = new zzev(this, "time_active", 0L);
    public boolean zzs;
    public zzew zzt;
    public zzew zzu;
    public zzev zzv;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzd();
        long l = this.zzm().elapsedRealtime();
        if (this.zzy != null && l < this.zzaa) {
            return new Pair((Object)this.zzy, (Object)this.zzz);
        }
        String string2 = string;
        this.zzaa = l + this.zzt().zza(string2, zzam.zze);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzn());
            if (info != null) {
                this.zzy = info.getId();
                this.zzz = info.isLimitAdTrackingEnabled();
            }
            if (this.zzy == null) {
                this.zzy = "";
            }
        }
        catch (Exception exception) {
            this.zzr().zzw().zza("Unable to get advertising id", exception);
            this.zzy = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzy, (Object)this.zzz);
    }

    @WorkerThread
    final String zzb(String string) {
        this.zzd();
        String string2 = (String)this.zza((String)string).first;
        MessageDigest messageDigest = zzjy.zzi();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzeu(zzfl zzfl2) {
        super(zzfl2);
        this.zzn = new zzex(this, "non_personalized_ads", null);
        this.zzo = new zzew(this, "use_dynamite_api", false);
        this.zzp = new zzew(this, "allow_remote_dynamite", false);
        this.zzg = new zzev(this, "midnight_offset", 0L);
        this.zzh = new zzev(this, "first_open_time", 0L);
        this.zzi = new zzev(this, "app_install_time", 0L);
        this.zzj = new zzex(this, "app_instance_id", null);
        this.zzt = new zzew(this, "app_backgrounded", false);
        this.zzu = new zzew(this, "deep_link_retrieval_complete", false);
        this.zzv = new zzev(this, "deep_link_retrieval_attempts", 0L);
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void f_() {
        this.zzx = this.zzn().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzs = this.zzx.getBoolean("has_been_opened", false);
        if (!this.zzs) {
            SharedPreferences.Editor editor = this.zzx.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzey(this, "health_monitor", Math.max(0L, (Long)zzam.zzf.zza(null)), null);
    }

    @WorkerThread
    private final SharedPreferences zzy() {
        this.zzd();
        this.zzaa();
        return this.zzx;
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzy().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzg() {
        this.zzd();
        return this.zzy().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzd(String string) {
        this.zzd();
        SharedPreferences.Editor editor = this.zzy().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzd();
        return this.zzy().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzi() {
        this.zzd();
        if (!this.zzy().contains("use_service")) {
            return null;
        }
        return this.zzy().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzy().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzj() {
        this.zzd();
        this.zzr().zzx().zza("Clearing collection preferences.");
        if (this.zzt().zza(zzam.zzbg)) {
            Boolean bl = this.zzk();
            SharedPreferences.Editor editor = this.zzy().edit();
            editor.clear();
            editor.apply();
            if (bl != null) {
                this.zzb(bl);
            }
            return;
        }
        boolean bl = this.zzy().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzc(true);
        }
        SharedPreferences.Editor editor = this.zzy().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.zzb(bl2);
        }
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzy().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzc(boolean bl) {
        this.zzd();
        return this.zzy().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    final Boolean zzk() {
        this.zzd();
        if (this.zzy().contains("measurement_enabled")) {
            return this.zzy().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzv() {
        this.zzd();
        String string = this.zzy().getString("previous_os_version", null);
        this.zzl().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzy().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzd(boolean bl) {
        this.zzd();
        this.zzr().zzx().zza("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzy().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzw() {
        this.zzd();
        return this.zzy().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzx() {
        return this.zzx.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzq.zza();
    }

    static /* synthetic */ SharedPreferences zza(zzeu zzeu2) {
        return zzeu2.zzy();
    }
}

