/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzjy;
import java.util.Map;

public final class zzhy
extends zze {
    @VisibleForTesting
    protected zzhv zza;
    private volatile zzhv zzb;
    private zzhv zzc;
    private final Map<Activity, zzhv> zzd = new ArrayMap();
    private zzhv zze;
    private String zzf;

    public zzhy(zzfl zzfl2) {
        super(zzfl2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzhv zzab() {
        this.zzw();
        ((zzgh)this).zzd();
        return this.zza;
    }

    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzb == null) {
            ((zzgh)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgh)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzhy.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzjy.zzd(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgh)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgh)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgh)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgh)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzhv zzhv2 = new zzhv(string, string2, ((zzgh)this).zzp().zzg());
        this.zzd.put(activity, zzhv2);
        this.zza(activity, zzhv2, true);
    }

    public final zzhv zzac() {
        ((zzgh)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzhv zzhv2, boolean bl) {
        zzhv zzhv3;
        zzhv zzhv4 = zzhv3 = this.zzb == null ? this.zzc : this.zzb;
        if (zzhv2.zzb == null) {
            zzhv2 = new zzhv(zzhv2.zza, zzhy.zza(activity.getClass().getCanonicalName()), zzhv2.zzc);
        }
        zzhv zzhv5 = zzhv2;
        this.zzc = this.zzb;
        this.zzb = zzhv5;
        ((zzgh)this).zzq().zza(new zzhx(this, bl, zzhv3, zzhv5));
    }

    @WorkerThread
    private final void zza(@NonNull zzhv zzhv2, boolean bl) {
        ((zzf)this).zze().zza(((zzgh)this).zzm().elapsedRealtime());
        if (((zzf)this).zzk().zza(zzhv2.zzd, bl)) {
            zzhv2.zzd = false;
        }
    }

    public static void zza(zzhv zzhv2, Bundle bundle, boolean bl) {
        if (bundle != null && zzhv2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzhv2.zza != null) {
                bundle.putString("_sn", zzhv2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzhv2.zzb);
            bundle.putLong("_si", zzhv2.zzc);
            return;
        }
        if (bundle != null && zzhv2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzhv zzhv2) {
        ((zzgh)this).zzd();
        zzhy zzhy2 = this;
        synchronized (zzhy2) {
            if (this.zzf == null || this.zzf.equals(string) || zzhv2 != null) {
                this.zzf = string;
                this.zze = zzhv2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzhv zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzhv zzhv2 = this.zzd.get(activity);
        if (zzhv2 == null) {
            String string = zzhy.zza(activity.getClass().getCanonicalName());
            zzhv2 = new zzhv(null, string, ((zzgh)this).zzp().zzg());
            this.zzd.put(activity, zzhv2);
        }
        return zzhv2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzhv zzhv2 = new zzhv(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzhv2);
    }

    @MainThread
    public final void zza(Activity activity) {
        zzhv zzhv2 = this.zzd(activity);
        this.zza(activity, zzhv2, false);
        zzb zzb2 = ((zzf)this).zze();
        long l = ((zzgh)zzb2).zzm().elapsedRealtime();
        ((zzgh)zzb2).zzq().zza(new zzc(zzb2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        zzhv zzhv2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgh)this).zzq().zza(new zzia(this, zzhv2));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzhv zzhv2 = this.zzd.get(activity);
        if (zzhv2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzhv2.zzc);
        bundle2.putString("name", zzhv2.zza);
        bundle2.putString("referrer_name", zzhv2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzhy zzhy2, zzhv zzhv2, boolean bl) {
        zzhy2.zza(zzhv2, bl);
    }
}

