/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzw;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class zzah
extends zzgu {
    private long zza;
    private String zzb;
    private Boolean zzc;
    private AccountManager zzd;
    private Boolean zze;
    private long zzf;

    zzah(zzga zzga2) {
        super(zzga2);
    }

    @Override
    protected final boolean zze() {
        Calendar calendar = Calendar.getInstance();
        this.zza = TimeUnit.MINUTES.convert(calendar.get(15) + calendar.get(16), TimeUnit.MILLISECONDS);
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage().toLowerCase(Locale.ENGLISH);
        String string2 = locale.getCountry().toLowerCase(Locale.ENGLISH);
        this.zzb = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
        return false;
    }

    public final long zzf() {
        this.zzaa();
        return this.zza;
    }

    public final String zzg() {
        this.zzaa();
        return this.zzb;
    }

    public final boolean zza(Context context) {
        if (this.zzc == null) {
            zzw zzw2 = ((zzgr)this).zzu();
            this.zzc = false;
            try {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null) {
                    packageManager.getPackageInfo("com.google.android.gms", 128);
                    this.zzc = true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return this.zzc;
    }

    @WorkerThread
    final long zzh() {
        ((zzgr)this).zzd();
        return this.zzf;
    }

    @WorkerThread
    final void zzi() {
        ((zzgr)this).zzd();
        this.zze = null;
        this.zzf = 0L;
    }

    @WorkerThread
    final boolean zzj() {
        ((zzgr)this).zzd();
        long l = ((zzgr)this).zzm().currentTimeMillis();
        if (l - this.zzf > 86400000L) {
            this.zze = null;
        }
        if (this.zze != null) {
            return this.zze;
        }
        if (ContextCompat.checkSelfPermission((Context)((zzgr)this).zzn(), (String)"android.permission.GET_ACCOUNTS") != 0) {
            ((zzgr)this).zzr().zzj().zza("Permission error checking for dasher/unicorn accounts");
            this.zzf = l;
            this.zze = false;
            return false;
        }
        if (this.zzd == null) {
            this.zzd = AccountManager.get((Context)((zzgr)this).zzn());
        }
        try {
            Account[] accountArray = (Account[])this.zzd.getAccountsByTypeAndFeatures("com.google", new String[]{"service_HOSTED"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zze = true;
                this.zzf = l;
                return true;
            }
            accountArray = (Account[])this.zzd.getAccountsByTypeAndFeatures("com.google", new String[]{"service_uca"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zze = true;
                this.zzf = l;
                return true;
            }
        }
        catch (AuthenticatorException | OperationCanceledException | IOException throwable) {
            ((zzgr)this).zzr().zzg().zza("Exception checking account types", throwable);
        }
        this.zzf = l;
        this.zze = false;
        return false;
    }
}

