/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcn;
import com.google.android.gms.internal.measurement.zzjy;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzgf
implements zzhc {
    private static volatile zzgf zza;
    private final Context zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final boolean zzf;
    private final zzw zzg;
    private final zzx zzh;
    private final zzfo zzi;
    private final zzfb zzj;
    private final zzgc zzk;
    private final zzjt zzl;
    private final zzkv zzm;
    private final zzez zzn;
    private final Clock zzo;
    private final zzin zzp;
    private final zzhk zzq;
    private final zzb zzr;
    private final zzii zzs;
    private zzex zzt;
    private zzis zzu;
    private zzah zzv;
    private zzey zzw;
    private zzfu zzx;
    private boolean zzy = false;
    private Boolean zzz;
    private long zzaa;
    private volatile Boolean zzab;
    @VisibleForTesting
    private Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    private int zzae;
    private AtomicInteger zzaf = new AtomicInteger(0);
    private final long zzag;

    private zzgf(zzhh zzhh2) {
        Object object;
        Preconditions.checkNotNull((Object)zzhh2);
        Object object2 = zzhh2.zza;
        zzer.zza = this.zzg = new zzw((Context)object2);
        this.zzb = zzhh2.zza;
        this.zzc = zzhh2.zzb;
        this.zzd = zzhh2.zzc;
        this.zze = zzhh2.zzd;
        this.zzf = zzhh2.zzh;
        this.zzab = zzhh2.zze;
        zzv zzv2 = zzhh2.zzg;
        if (zzv2 != null && zzv2.zzg != null) {
            object = zzv2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzac = (Boolean)object;
            }
            if ((object = zzv2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
        }
        zzcn.zza(this.zzb);
        this.zzo = DefaultClock.getInstance();
        this.zzag = this.zzo.currentTimeMillis();
        object2 = this;
        this.zzh = new zzx((zzgf)object2);
        object2 = this;
        object = new zzfo((zzgf)object2);
        ((zzgz)object).zzab();
        this.zzi = object;
        object2 = this;
        zzfb zzfb2 = new zzfb((zzgf)object2);
        zzfb2.zzab();
        this.zzj = zzfb2;
        object2 = this;
        zzkv zzkv2 = new zzkv((zzgf)object2);
        zzkv2.zzab();
        this.zzm = zzkv2;
        object2 = this;
        zzez zzez2 = new zzez((zzgf)object2);
        zzez2.zzab();
        this.zzn = zzez2;
        object2 = this;
        this.zzr = new zzb((zzgf)object2);
        object2 = this;
        zzin zzin2 = new zzin((zzgf)object2);
        zzin2.zzx();
        this.zzp = zzin2;
        object2 = this;
        zzhk zzhk2 = new zzhk((zzgf)object2);
        zzhk2.zzx();
        this.zzq = zzhk2;
        object2 = this;
        zzjt zzjt2 = new zzjt((zzgf)object2);
        zzjt2.zzx();
        this.zzl = zzjt2;
        object2 = this;
        zzii zzii2 = new zzii((zzgf)object2);
        zzii2.zzab();
        this.zzs = zzii2;
        object2 = this;
        zzgc zzgc2 = new zzgc((zzgf)object2);
        zzgc2.zzab();
        this.zzk = zzgc2;
        boolean bl = zzhh2.zzg != null && zzhh2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzw zzw2 = ((zzgf)object2).zzg;
        if (((zzgf)object2).zzb.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhk zzhk3 = ((zzgf)object2).zzh();
            if (((zzha)zzhk3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzha)zzhk3).zzn().getApplicationContext();
                if (zzhk3.zza == null) {
                    zzhk3.zza = new zzid(zzhk3, null);
                }
                if (bl3) {
                    zzid zzid2 = zzhk3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzid2);
                    zzid2 = zzhk3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzid2);
                    ((zzha)zzhk3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzgf)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzk.zza(new zzgh(this, zzhh2));
    }

    @WorkerThread
    private final void zza(zzhh zzhh2) {
        ((zzha)this.zzq()).zzd();
        Object object = this;
        zzah zzah2 = new zzah((zzgf)object);
        zzah2.zzab();
        this.zzv = zzah2;
        zzgf zzgf2 = this;
        object = zzhh2;
        zzey zzey2 = new zzey(zzgf2, ((zzhh)object).zzf);
        zzey2.zzx();
        this.zzw = zzey2;
        object = this;
        zzex zzex2 = new zzex((zzgf)object);
        zzex2.zzx();
        this.zzt = zzex2;
        object = this;
        zzis zzis2 = new zzis((zzgf)object);
        zzis2.zzx();
        this.zzu = zzis2;
        this.zzm.zzac();
        this.zzi.zzac();
        object = this;
        this.zzx = new zzfu((zzgf)object);
        this.zzw.zzy();
        this.zzr().zzv().zza("App measurement initialized, version", this.zzh.zze());
        zzw zzw2 = this.zzg;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzw2 = this.zzg;
        String string = zzey2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            String string2;
            zzfd zzfd2;
            if (this.zzi().zzf(string)) {
                zzfd2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzfd2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzfd2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzae != this.zzaf.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzae, this.zzaf.get());
        }
        this.zzy = true;
    }

    @WorkerThread
    protected final void zza() {
        ((zzha)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzo.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zzag);
            this.zzc().zzh.zza(this.zzag);
        }
        if (!this.zzah()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzw zzw2 = this.zzg;
                if (!Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() && !this.zzh.zzx()) {
                    if (!zzfv.zza(this.zzb)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkv.zza(this.zzb, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzw zzw3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzkv.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzu.zzah();
                    this.zzu.zzaf();
                    this.zzc().zzh.zza(this.zzag);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzw3 = this.zzg;
            if (zzjy.zzb() && this.zzh.zza(zzap.zzco) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzw.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzw.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzh.zzg()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzh.zza(zzap.zzbg));
        this.zzc().zzp.zza(this.zzh.zza(zzap.zzbh));
    }

    @Override
    public final zzw zzu() {
        return this.zzg;
    }

    public final zzx zzb() {
        return this.zzh;
    }

    public final zzfo zzc() {
        zzgf.zza(this.zzi);
        return this.zzi;
    }

    @Override
    public final zzfb zzr() {
        zzgf.zzb(this.zzj);
        return this.zzj;
    }

    public final zzfb zzd() {
        if (this.zzj != null && this.zzj.zzz()) {
            return this.zzj;
        }
        return null;
    }

    @Override
    public final zzgc zzq() {
        zzgf.zzb(this.zzk);
        return this.zzk;
    }

    public final zzjt zze() {
        zzgf.zzb(this.zzl);
        return this.zzl;
    }

    public final zzfu zzf() {
        return this.zzx;
    }

    final zzgc zzg() {
        return this.zzk;
    }

    public final zzhk zzh() {
        zzgf.zzb(this.zzq);
        return this.zzq;
    }

    public final zzkv zzi() {
        zzgf.zza(this.zzm);
        return this.zzm;
    }

    public final zzez zzj() {
        zzgf.zza(this.zzn);
        return this.zzn;
    }

    public final zzex zzk() {
        zzgf.zzb(this.zzt);
        return this.zzt;
    }

    private final zzii zzaj() {
        zzgf.zzb(this.zzs);
        return this.zzs;
    }

    @Override
    public final Context zzn() {
        return this.zzb;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final String zzo() {
        return this.zzc;
    }

    public final String zzp() {
        return this.zzd;
    }

    public final String zzs() {
        return this.zze;
    }

    public final boolean zzt() {
        return this.zzf;
    }

    @Override
    public final Clock zzm() {
        return this.zzo;
    }

    public final zzin zzv() {
        zzgf.zzb(this.zzp);
        return this.zzp;
    }

    public final zzis zzw() {
        zzgf.zzb(this.zzu);
        return this.zzu;
    }

    public final zzah zzx() {
        zzgf.zzb(this.zzv);
        return this.zzv;
    }

    public final zzey zzy() {
        zzgf.zzb(this.zzw);
        return this.zzw;
    }

    public final zzb zzz() {
        if (this.zzr == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzr;
    }

    @VisibleForTesting
    public static zzgf zza(Context context, String string, String string2, Bundle bundle) {
        return zzgf.zza(context, new zzv(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgf zza(Context context, zzv zzv2) {
        if (zzv2 != null && (zzv2.zze == null || zzv2.zzf == null)) {
            zzv2 = new zzv(zzv2.zza, zzv2.zzb, zzv2.zzc, zzv2.zzd, null, null, zzv2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza == null) {
            Class<zzgf> clazz = zzgf.class;
            synchronized (zzgf.class) {
                if (zza == null) {
                    zzhh zzhh2 = new zzhh(context, zzv2);
                    zza = new zzgf(zzhh2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzv2 != null && zzv2.zzg != null && zzv2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zza.zza(zzv2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zza;
    }

    private final void zzak() {
        if (!this.zzy) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zzb(zzgz zzgz2) {
        if (zzgz2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgz2.zzz()) {
            String string = String.valueOf(zzgz2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzv()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzha zzha2) {
        if (zzha2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzab = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab != null && this.zzab != false;
    }

    @WorkerThread
    public final boolean zzab() {
        if (com.google.android.gms.internal.measurement.zzkv.zzb() && this.zzh.zza(zzap.zzcw)) {
            return this.zzac() == 0;
        }
        zzgf zzgf2 = this;
        ((zzha)zzgf2.zzq()).zzd();
        zzgf2.zzak();
        if (zzgf2.zzh.zzg()) {
            return false;
        }
        if (zzgf2.zzad != null && zzgf2.zzad.booleanValue()) {
            return false;
        }
        Boolean bl = zzgf2.zzc().zzv();
        if (bl != null) {
            return bl;
        }
        Boolean bl2 = zzgf2.zzh.zzh();
        if (bl2 != null) {
            return bl2;
        }
        if (zzgf2.zzac != null) {
            return zzgf2.zzac;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return false;
        }
        if (zzgf2.zzh.zza(zzap.zzaw) && zzgf2.zzab != null) {
            return zzgf2.zzab;
        }
        return true;
    }

    @WorkerThread
    public final int zzac() {
        ((zzha)this.zzq()).zzd();
        if (this.zzh.zzg()) {
            return 1;
        }
        if (this.zzad != null && this.zzad.booleanValue()) {
            return 2;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        Boolean bl2 = this.zzh.zzh();
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzh.zza(zzap.zzaw) && this.zzab != null) {
            if (this.zzab.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    final long zzad() {
        Long l = this.zzc().zzh.zza();
        if (l == 0L) {
            return this.zzag;
        }
        return Math.min(this.zzag, l);
    }

    final void zzae() {
        zzw zzw2 = this.zzg;
    }

    final void zzaf() {
        zzw zzw2 = this.zzg;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgz zzgz2) {
        ++this.zzae;
    }

    final void zza(zze zze2) {
        ++this.zzae;
    }

    final void zzag() {
        this.zzaf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzah() {
        this.zzak();
        ((zzha)this.zzq()).zzd();
        if (this.zzz == null || this.zzaa == 0L || this.zzz != null && !this.zzz.booleanValue() && Math.abs(this.zzo.elapsedRealtime() - this.zzaa) > 1000L) {
            this.zzaa = this.zzo.elapsedRealtime();
            zzw zzw2 = this.zzg;
            this.zzz = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() || this.zzh.zzx() || zzfv.zza(this.zzb) && zzkv.zza(this.zzb, false));
            if (this.zzz.booleanValue()) {
                this.zzz = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzz;
    }

    @WorkerThread
    public final void zzai() {
        ((zzha)this.zzq()).zzd();
        zzgf.zzb(this.zzaj());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzh.zzi().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzaj().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzha)this.zzy()).zzt().zze(), string, (String)pair.first, this.zzc().zzv.zza() - 1L);
        zzgi zzgi2 = new zzgi(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzii zzii2 = this.zzaj();
        ((zzha)zzii2).zzd();
        zzii2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzgi2);
        ((zzha)zzii2).zzq().zzb(new zzik(zzii2, string2, uRL2, null, null, zzgi2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzgf zzgf2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzgf2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzgf2.zzc().zzu.zza(true);
        if (byArray2.length == 0) {
            zzgf2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzgf2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkv zzkv2 = zzgf2.zzi();
            ((zzha)zzkv2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzha)zzkv2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzgf2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzgf2.zzq.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkv2 = zzgf2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkv2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzha)zzkv2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzgf2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzgf zzgf2, zzhh zzhh2) {
        zzgf2.zza(zzhh2);
    }
}

