/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzkv;
import java.util.Map;

public final class zzin
extends zze {
    @VisibleForTesting
    protected zzio zza;
    private volatile zzio zzb;
    private zzio zzc;
    private final Map<Activity, zzio> zzd = new ArrayMap();
    private zzio zze;
    private String zzf;

    public zzin(zzgf zzgf2) {
        super(zzgf2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzio zzab() {
        this.zzw();
        ((zzha)this).zzd();
        return this.zza;
    }

    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzb == null) {
            ((zzha)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzha)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzin.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzkv.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzha)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzha)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzha)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzha)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzio zzio2 = new zzio(string, string2, ((zzha)this).zzp().zzg());
        this.zzd.put(activity, zzio2);
        this.zza(activity, zzio2, true);
    }

    public final zzio zzac() {
        ((zzha)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzio zzio2, boolean bl) {
        zzio zzio3;
        zzio zzio4 = zzio3 = this.zzb == null ? this.zzc : this.zzb;
        if (zzio2.zzb == null) {
            zzio2 = new zzio(zzio2.zza, zzin.zza(activity.getClass().getCanonicalName()), zzio2.zzc);
        }
        zzio zzio5 = zzio2;
        this.zzc = this.zzb;
        this.zzb = zzio5;
        long l = ((zzha)this).zzm().elapsedRealtime();
        ((zzha)this).zzq().zza(new zziq(this, bl, l, zzio3, zzio5));
    }

    @WorkerThread
    private final void zza(@NonNull zzio zzio2, boolean bl, long l) {
        ((zzf)this).zze().zza(((zzha)this).zzm().elapsedRealtime());
        if (((zzf)this).zzk().zza(zzio2.zzd, bl, l)) {
            zzio2.zzd = false;
        }
    }

    public static void zza(zzio zzio2, Bundle bundle, boolean bl) {
        if (bundle != null && zzio2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzio2.zza != null) {
                bundle.putString("_sn", zzio2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzio2.zzb);
            bundle.putLong("_si", zzio2.zzc);
            return;
        }
        if (bundle != null && zzio2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzio zzio2) {
        ((zzha)this).zzd();
        zzin zzin2 = this;
        synchronized (zzin2) {
            if (this.zzf == null || this.zzf.equals(string) || zzio2 != null) {
                this.zzf = string;
                this.zze = zzio2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzio zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzio zzio2 = this.zzd.get(activity);
        if (zzio2 == null) {
            String string = zzin.zza(activity.getClass().getCanonicalName());
            zzio2 = new zzio(null, string, ((zzha)this).zzp().zzg());
            this.zzd.put(activity, zzio2);
        }
        return zzio2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzio zzio2 = new zzio(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzio2);
    }

    @MainThread
    public final void zza(Activity activity) {
        zzio zzio2 = this.zzd(activity);
        this.zza(activity, zzio2, false);
        zzb zzb2 = ((zzf)this).zze();
        long l = ((zzha)zzb2).zzm().elapsedRealtime();
        ((zzha)zzb2).zzq().zza(new zzc(zzb2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        zzio zzio2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        long l = ((zzha)this).zzm().elapsedRealtime();
        ((zzha)this).zzq().zza(new zzip(this, zzio2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzio zzio2 = this.zzd.get(activity);
        if (zzio2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzio2.zzc);
        bundle2.putString("name", zzio2.zza);
        bundle2.putString("referrer_name", zzio2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzin zzin2, zzio zzio2, boolean bl, long l) {
        zzin2.zza(zzio2, bl, l);
    }
}

