/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzis
extends zze {
    private final zzjk zza;
    private zzet zzb;
    private volatile Boolean zzc;
    private final zzaf zzd;
    private final zzkg zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzaf zzg;

    protected zzis(zzgf zzgf2) {
        super(zzgf2);
        this.zze = new zzkg(zzgf2.zzm());
        this.zza = new zzjk(this);
        this.zzd = new zzir(this, zzgf2);
        this.zzg = new zzjc(this, zzgf2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzha)this).zzd();
        this.zzw();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzac() {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(true);
        this.zza(new zzjb(this, zzm2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzet zzet2, AbstractSafeParcelable abstractSafeParcelable, zzm zzm2) {
        ((zzha)this).zzd();
        ((zzha)this).zzb();
        this.zzw();
        boolean bl = this.zzai();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzf)this).zzj().zza(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzan) {
                    try {
                        zzet2.zza((zzan)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzha)this).zzr().zzf().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkq) {
                    try {
                        zzet2.zza((zzkq)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzha)this).zzr().zzf().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzv) {
                    try {
                        zzet2.zza((zzv)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzha)this).zzr().zzf().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzha)this).zzr().zzf().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzan zzan2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzan2));
        ((zzha)this).zzd();
        this.zzw();
        boolean bl = this.zzai();
        boolean bl2 = bl && ((zzf)this).zzj().zza(zzan2);
        zzm zzm2 = this.zza(true);
        this.zza(new zzje(this, bl, bl2, zzan2, zzm2, string));
    }

    @WorkerThread
    protected final void zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)((Object)zzv2));
        ((zzha)this).zzd();
        this.zzw();
        zzw zzw2 = ((zzha)this).zzu();
        boolean bl = true;
        boolean bl2 = true && ((zzf)this).zzj().zza(zzv2);
        zzv zzv3 = new zzv(zzv2);
        zzm zzm2 = this.zza(true);
        this.zza(new zzjd(this, bl, bl2, zzv3, zzm2, zzv2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzv>> atomicReference, String string, String string2, String string3) {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjg(this, atomicReference, string, string2, string3, zzm2));
    }

    @WorkerThread
    protected final void zza(zzn zzn2, String string, String string2) {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjf(this, string, string2, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkq>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzji(this, atomicReference, string, string2, string3, bl, zzm2));
    }

    @WorkerThread
    protected final void zza(zzn zzn2, String string, String string2, boolean bl) {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjh(this, string, string2, bl, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zza(zzkq zzkq2) {
        ((zzha)this).zzd();
        this.zzw();
        boolean bl = this.zzai() && ((zzf)this).zzj().zza(zzkq2);
        zzm zzm2 = this.zza(true);
        this.zza(new zziu(this, bl, zzkq2, zzm2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkq>> atomicReference, boolean bl) {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzit(this, atomicReference, zzm2, bl));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzha)this).zzd();
        ((zzha)this).zzb();
        this.zzw();
        zzm zzm2 = this.zza(false);
        if (this.zzai()) {
            ((zzf)this).zzj().zzab();
        }
        this.zza(new zziw(this, zzm2));
    }

    private final boolean zzai() {
        zzw zzw2 = ((zzha)this).zzu();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zziv(this, atomicReference, zzm2));
    }

    @WorkerThread
    public final void zza(zzn zzn2) {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zziy(this, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zzae() {
        ((zzha)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(true);
        boolean bl = ((zzha)this).zzt().zza(zzap.zzbx);
        if (bl) {
            ((zzf)this).zzj().zzac();
        }
        this.zza(new zzix(this, zzm2, bl));
    }

    @WorkerThread
    protected final void zza(zzio zzio2) {
        ((zzha)this).zzd();
        this.zzw();
        this.zza(new zzja(this, zzio2));
    }

    @WorkerThread
    private final void zzaj() {
        ((zzha)this).zzd();
        this.zze.zza();
        this.zzd.zza((Long)zzap.zzaf.zza(null));
    }

    @WorkerThread
    final void zzaf() {
        zzw zzw2;
        Boolean bl;
        zzis zzis2;
        ((zzha)this).zzd();
        this.zzw();
        if (this.zzab()) {
            return;
        }
        if (this.zzc == null) {
            boolean bl2;
            zzis2 = this;
            ((zzha)zzis2).zzd();
            zzis2.zzw();
            bl = ((zzha)zzis2).zzs().zzj();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzw2 = ((zzha)zzis2).zzu();
                if (((zzf)zzis2).zzg().zzag() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzha)zzis2).zzr().zzx().zza("Checking service availability");
                    int n = ((zzha)zzis2).zzp().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzha)zzis2).zzr().zzx().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzha)zzis2).zzr().zzx().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzha)zzis2).zzr().zzi().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzha)zzis2).zzr().zzw().zza("Service container out of date");
                            if (((zzha)zzis2).zzp().zzj() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzha)zzis2).zzs().zzj();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzha)zzis2).zzr().zzi().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzha)zzis2).zzr().zzi().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzha)zzis2).zzr().zzi().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzha)zzis2).zzt().zzx()) {
                    ((zzha)zzis2).zzr().zzf().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzha)zzis2).zzs().zza(bl4);
                }
                bl2 = bl4;
            }
            this.zzc = bl2;
        }
        if (this.zzc.booleanValue()) {
            this.zza.zzb();
            return;
        }
        if (!((zzha)this).zzt().zzx()) {
            Intent intent;
            zzis2 = this;
            zzw2 = ((zzha)zzis2).zzu();
            bl = ((zzha)zzis2).zzn().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzha)zzis2).zzn(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzw2 = ((zzha)this).zzu();
                intent2.setComponent(new ComponentName(((zzha)this).zzn(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzha)this).zzr().zzf().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzag() {
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzet zzet2) {
        ((zzha)this).zzd();
        Preconditions.checkNotNull((Object)zzet2);
        this.zzb = zzet2;
        this.zzaj();
        this.zzal();
    }

    @WorkerThread
    public final void zzah() {
        ((zzha)this).zzd();
        this.zzw();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzha)this).zzn(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzha)this).zzd();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzha)this).zzr().zzx().zza("Disconnected from device MeasurementService", componentName);
            zzis zzis2 = this;
            ((zzha)zzis2).zzd();
            zzis2.zzaf();
        }
    }

    @WorkerThread
    private final void zzak() {
        ((zzha)this).zzd();
        if (!this.zzab()) {
            return;
        }
        ((zzha)this).zzr().zzx().zza("Inactivity, disconnecting from the service");
        this.zzah();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzha)this).zzd();
        if (this.zzab()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzha)this).zzr().zzf().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzaf();
    }

    @WorkerThread
    private final void zzal() {
        ((zzha)this).zzd();
        ((zzha)this).zzr().zzx().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzha)this).zzr().zzf().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzm zza(boolean bl) {
        zzw zzw2 = ((zzha)this).zzu();
        return ((zzf)this).zzg().zza(bl ? ((zzha)this).zzr().zzy() : null);
    }

    @WorkerThread
    public final void zza(zzn zzn2, zzan zzan2, String string) {
        ((zzha)this).zzd();
        this.zzw();
        int n = ((zzha)this).zzp().zza(12451000);
        if (n != 0) {
            ((zzha)this).zzr().zzi().zza("Not bundling data. Service unavailable or out of date");
            ((zzha)this).zzp().zza(zzn2, new byte[0]);
            return;
        }
        this.zza(new zziz(this, zzan2, string, zzn2));
    }

    static /* synthetic */ zzjk zza(zzis zzis2) {
        return zzis2.zza;
    }

    static /* synthetic */ void zza(zzis zzis2, ComponentName componentName) {
        zzis2.zza(componentName);
    }

    static /* synthetic */ zzet zza(zzis zzis2, zzet zzet2) {
        zzis2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzis zzis2) {
        zzis2.zzal();
    }

    static /* synthetic */ void zzc(zzis zzis2) {
        zzis2.zzak();
    }

    static /* synthetic */ zzet zzd(zzis zzis2) {
        return zzis2.zzb;
    }

    static /* synthetic */ void zze(zzis zzis2) {
        zzis2.zzaj();
    }
}

