/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzln;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzx
extends zzha {
    private Boolean zza;
    @NonNull
    private zzz zzb = zzaa.zza;
    private Boolean zzc;

    zzx(zzgf zzgf2) {
        super(zzgf2);
    }

    final void zza(@NonNull zzz zzz2) {
        this.zzb = zzz2;
    }

    @WorkerThread
    public final int zza(@Size(min=1L) String string) {
        return this.zzb(string, zzap.zzn);
    }

    public final long zze() {
        zzw zzw2 = ((zzha)this).zzu();
        return 21028L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzf() {
        if (this.zzc == null) {
            zzx zzx2 = this;
            synchronized (zzx2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzha)this).zzn().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzha)this).zzr().zzf().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzeu<Long> zzeu2) {
        if (string == null) {
            return zzeu2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeu2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeu2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzeu2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeu2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzeu<Integer> zzeu2) {
        if (string == null) {
            return zzeu2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeu2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeu2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzeu2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeu2.zza(null);
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzeu<Double> zzeu2) {
        if (string == null) {
            return zzeu2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeu2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeu2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzeu2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeu2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzeu<Boolean> zzeu2) {
        if (string == null) {
            return zzeu2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeu2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeu2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzeu2.zza(bl);
    }

    public final boolean zze(String string, zzeu<Boolean> zzeu2) {
        return this.zzd(string, zzeu2);
    }

    public final boolean zza(zzeu<Boolean> zzeu2) {
        zzeu<Boolean> zzeu3 = zzeu2;
        return this.zzd(null, zzeu3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzy() {
        try {
            if (((zzha)this).zzn().getPackageManager() == null) {
                ((zzha)this).zzr().zzf().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzha)this).zzn()).getApplicationInfo(((zzha)this).zzn().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzha)this).zzr().zzf().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzha)this).zzr().zzf().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzb(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzy();
        if (bundle == null) {
            ((zzha)this).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzc(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzx zzx2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzx2.zzy();
        if (bundle == null) {
            ((zzha)zzx2).zzr().zzf().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzha)this).zzn().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzha)this).zzr().zzf().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzg() {
        zzw zzw2 = ((zzha)this).zzu();
        Boolean bl = this.zzb("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzh() {
        zzw zzw2 = ((zzha)this).zzu();
        return this.zzb("firebase_analytics_collection_enabled");
    }

    public final Boolean zzi() {
        ((zzha)this).zzb();
        Boolean bl = this.zzb("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public static long zzj() {
        return zzap.zzac.zza(null);
    }

    public final String zza(zzg zzg2) {
        String string;
        Uri.Builder builder;
        block2: {
            block3: {
                builder = new Uri.Builder();
                string = zzg2.zze();
                if (!TextUtils.isEmpty((CharSequence)string)) break block2;
                if (!zzln.zzb()) break block3;
                zzeu<Boolean> zzeu2 = zzap.zzcf;
                String string2 = zzg2.zzc();
                if (((zzha)this).zzt().zzd(string2, zzeu2) && !TextUtils.isEmpty((CharSequence)(string = zzg2.zzg()))) break block2;
            }
            string = zzg2.zzf();
        }
        String string3 = String.valueOf(string);
        builder.scheme((String)zzap.zzd.zza(null)).encodedAuthority((String)zzap.zze.zza(null)).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", zzg2.zzd()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(this.zze()));
        return builder.build().toString();
    }

    public static long zzk() {
        return zzap.zzc.zza(null);
    }

    public final String zzv() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzw() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzha)this).zzr().zzf().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzha)this).zzr().zzf().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzha)this).zzr().zzf().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzha)this).zzr().zzf().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public final boolean zzd(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zze(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzf(String string) {
        return this.zzd(string, zzap.zzag);
    }

    @WorkerThread
    final String zzg(String string) {
        zzeu<String> zzeu2 = zzap.zzah;
        String string2 = string;
        zzx zzx2 = this;
        if (string2 == null) {
            return zzeu2.zza(null);
        }
        return zzeu2.zza(zzx2.zzb.zza(string2, zzeu2.zza()));
    }

    @WorkerThread
    final boolean zzx() {
        if (this.zza == null) {
            this.zza = this.zzb("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzx.zzt();
    }
}

