/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkt;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzgo
implements zzhh {
    private static volatile zzgo zza;
    private final Context zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final boolean zzf;
    private final zzw zzg;
    private final zzx zzh;
    private final zzft zzi;
    private final zzfk zzj;
    private final zzgh zzk;
    private final zzkc zzl;
    private final zzla zzm;
    private final zzfi zzn;
    private final Clock zzo;
    private final zziw zzp;
    private final zzhp zzq;
    private final zzb zzr;
    private final zzin zzs;
    private zzfg zzt;
    private zzix zzu;
    private zzah zzv;
    private zzfd zzw;
    private zzfz zzx;
    private boolean zzy = false;
    private Boolean zzz;
    private long zzaa;
    private volatile Boolean zzab;
    @VisibleForTesting
    private Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    private int zzae;
    private AtomicInteger zzaf = new AtomicInteger(0);
    private final long zzag;

    private zzgo(zzhq zzhq2) {
        Object object;
        Preconditions.checkNotNull((Object)zzhq2);
        Object object2 = zzhq2.zza;
        zzfa.zza = this.zzg = new zzw((Context)object2);
        this.zzb = zzhq2.zza;
        this.zzc = zzhq2.zzb;
        this.zzd = zzhq2.zzc;
        this.zze = zzhq2.zzd;
        this.zzf = zzhq2.zzh;
        this.zzab = zzhq2.zze;
        zzv zzv2 = zzhq2.zzg;
        if (zzv2 != null && zzv2.zzg != null) {
            object = zzv2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzac = (Boolean)object;
            }
            if ((object = zzv2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
        }
        zzcl.zza(this.zzb);
        this.zzo = DefaultClock.getInstance();
        this.zzag = this.zzo.currentTimeMillis();
        object2 = this;
        this.zzh = new zzx((zzgo)object2);
        object2 = this;
        object = new zzft((zzgo)object2);
        ((zzhi)object).zzab();
        this.zzi = object;
        object2 = this;
        zzfk zzfk2 = new zzfk((zzgo)object2);
        zzfk2.zzab();
        this.zzj = zzfk2;
        object2 = this;
        zzla zzla2 = new zzla((zzgo)object2);
        zzla2.zzab();
        this.zzm = zzla2;
        object2 = this;
        zzfi zzfi2 = new zzfi((zzgo)object2);
        zzfi2.zzab();
        this.zzn = zzfi2;
        object2 = this;
        this.zzr = new zzb((zzgo)object2);
        object2 = this;
        zziw zziw2 = new zziw((zzgo)object2);
        zziw2.zzx();
        this.zzp = zziw2;
        object2 = this;
        zzhp zzhp2 = new zzhp((zzgo)object2);
        zzhp2.zzx();
        this.zzq = zzhp2;
        object2 = this;
        zzkc zzkc2 = new zzkc((zzgo)object2);
        zzkc2.zzx();
        this.zzl = zzkc2;
        object2 = this;
        zzin zzin2 = new zzin((zzgo)object2);
        zzin2.zzab();
        this.zzs = zzin2;
        object2 = this;
        zzgh zzgh2 = new zzgh((zzgo)object2);
        zzgh2.zzab();
        this.zzk = zzgh2;
        boolean bl = zzhq2.zzg != null && zzhq2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzw zzw2 = ((zzgo)object2).zzg;
        if (((zzgo)object2).zzb.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhp zzhp3 = ((zzgo)object2).zzh();
            if (((zzhf)zzhp3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzhf)zzhp3).zzn().getApplicationContext();
                if (zzhp3.zza == null) {
                    zzhp3.zza = new zzim(zzhp3, null);
                }
                if (bl3) {
                    zzim zzim2 = zzhp3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzim2);
                    zzim2 = zzhp3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzim2);
                    ((zzhf)zzhp3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzgo)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzk.zza(new zzgq(this, zzhq2));
    }

    @WorkerThread
    private final void zza(zzhq zzhq2) {
        ((zzhf)this.zzq()).zzd();
        Object object = this;
        zzah zzah2 = new zzah((zzgo)object);
        zzah2.zzab();
        this.zzv = zzah2;
        zzgo zzgo2 = this;
        object = zzhq2;
        zzfd zzfd2 = new zzfd(zzgo2, ((zzhq)object).zzf);
        zzfd2.zzx();
        this.zzw = zzfd2;
        object = this;
        zzfg zzfg2 = new zzfg((zzgo)object);
        zzfg2.zzx();
        this.zzt = zzfg2;
        object = this;
        zzix zzix2 = new zzix((zzgo)object);
        zzix2.zzx();
        this.zzu = zzix2;
        this.zzm.zzac();
        this.zzi.zzac();
        object = this;
        this.zzx = new zzfz((zzgo)object);
        this.zzw.zzy();
        this.zzr().zzv().zza("App measurement initialized, version", this.zzh.zze());
        zzw zzw2 = this.zzg;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzw2 = this.zzg;
        String string = zzfd2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            String string2;
            zzfm zzfm2;
            if (this.zzi().zzf(string)) {
                zzfm2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzfm2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzfm2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzae != this.zzaf.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzae, this.zzaf.get());
        }
        this.zzy = true;
    }

    @WorkerThread
    protected final void zza() {
        ((zzhf)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzo.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zzag);
            this.zzc().zzh.zza(this.zzag);
        }
        if (!this.zzah()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzw zzw2 = this.zzg;
                if (!Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() && !this.zzh.zzx()) {
                    if (!zzge.zza(this.zzb)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzla.zza(this.zzb, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzw zzw3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzla.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzu.zzah();
                    this.zzu.zzaf();
                    this.zzc().zzh.zza(this.zzag);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzw3 = this.zzg;
            if (zzka.zzb() && this.zzh.zza(zzap.zzcq) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzw.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzw.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzh.zzg()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzh.zza(zzap.zzbi));
        this.zzc().zzp.zza(this.zzh.zza(zzap.zzbj));
    }

    @Override
    public final zzw zzu() {
        return this.zzg;
    }

    public final zzx zzb() {
        return this.zzh;
    }

    public final zzft zzc() {
        zzgo.zza(this.zzi);
        return this.zzi;
    }

    @Override
    public final zzfk zzr() {
        zzgo.zzb(this.zzj);
        return this.zzj;
    }

    public final zzfk zzd() {
        if (this.zzj != null && this.zzj.zzz()) {
            return this.zzj;
        }
        return null;
    }

    @Override
    public final zzgh zzq() {
        zzgo.zzb(this.zzk);
        return this.zzk;
    }

    public final zzkc zze() {
        zzgo.zzb(this.zzl);
        return this.zzl;
    }

    public final zzfz zzf() {
        return this.zzx;
    }

    final zzgh zzg() {
        return this.zzk;
    }

    public final zzhp zzh() {
        zzgo.zzb(this.zzq);
        return this.zzq;
    }

    public final zzla zzi() {
        zzgo.zza(this.zzm);
        return this.zzm;
    }

    public final zzfi zzj() {
        zzgo.zza(this.zzn);
        return this.zzn;
    }

    public final zzfg zzk() {
        zzgo.zzb(this.zzt);
        return this.zzt;
    }

    private final zzin zzaj() {
        zzgo.zzb(this.zzs);
        return this.zzs;
    }

    @Override
    public final Context zzn() {
        return this.zzb;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final String zzo() {
        return this.zzc;
    }

    public final String zzp() {
        return this.zzd;
    }

    public final String zzs() {
        return this.zze;
    }

    public final boolean zzt() {
        return this.zzf;
    }

    @Override
    public final Clock zzm() {
        return this.zzo;
    }

    public final zziw zzv() {
        zzgo.zzb(this.zzp);
        return this.zzp;
    }

    public final zzix zzw() {
        zzgo.zzb(this.zzu);
        return this.zzu;
    }

    public final zzah zzx() {
        zzgo.zzb(this.zzv);
        return this.zzv;
    }

    public final zzfd zzy() {
        zzgo.zzb(this.zzw);
        return this.zzw;
    }

    public final zzb zzz() {
        if (this.zzr == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzr;
    }

    @VisibleForTesting
    public static zzgo zza(Context context, String string, String string2, Bundle bundle) {
        return zzgo.zza(context, new zzv(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgo zza(Context context, zzv zzv2) {
        if (zzv2 != null && (zzv2.zze == null || zzv2.zzf == null)) {
            zzv2 = new zzv(zzv2.zza, zzv2.zzb, zzv2.zzc, zzv2.zzd, null, null, zzv2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza == null) {
            Class<zzgo> clazz = zzgo.class;
            synchronized (zzgo.class) {
                if (zza == null) {
                    zzhq zzhq2 = new zzhq(context, zzv2);
                    zza = new zzgo(zzhq2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzv2 != null && zzv2.zzg != null && zzv2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zza.zza(zzv2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zza;
    }

    private final void zzak() {
        if (!this.zzy) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zzb(zzhi zzhi2) {
        if (zzhi2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzhi2.zzz()) {
            String string = String.valueOf(zzhi2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzv()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzhf zzhf2) {
        if (zzhf2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzab = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab != null && this.zzab != false;
    }

    @WorkerThread
    public final boolean zzab() {
        if (zzkt.zzb() && this.zzh.zza(zzap.zzcy)) {
            return this.zzac() == 0;
        }
        zzgo zzgo2 = this;
        ((zzhf)zzgo2.zzq()).zzd();
        zzgo2.zzak();
        if (zzgo2.zzh.zzg()) {
            return false;
        }
        if (zzgo2.zzad != null && zzgo2.zzad.booleanValue()) {
            return false;
        }
        Boolean bl = zzgo2.zzc().zzv();
        if (bl != null) {
            return bl;
        }
        Boolean bl2 = zzgo2.zzh.zzh();
        if (bl2 != null) {
            return bl2;
        }
        if (zzgo2.zzac != null) {
            return zzgo2.zzac;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return false;
        }
        if (zzgo2.zzh.zza(zzap.zzaz) && zzgo2.zzab != null) {
            return zzgo2.zzab;
        }
        return true;
    }

    @WorkerThread
    public final int zzac() {
        ((zzhf)this.zzq()).zzd();
        if (this.zzh.zzg()) {
            return 1;
        }
        if (this.zzad != null && this.zzad.booleanValue()) {
            return 2;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        Boolean bl2 = this.zzh.zzh();
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzh.zza(zzap.zzaz) && this.zzab != null) {
            if (this.zzab.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    final long zzad() {
        Long l = this.zzc().zzh.zza();
        if (l == 0L) {
            return this.zzag;
        }
        return Math.min(this.zzag, l);
    }

    final void zzae() {
        zzw zzw2 = this.zzg;
    }

    final void zzaf() {
        zzw zzw2 = this.zzg;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzhi zzhi2) {
        ++this.zzae;
    }

    final void zza(zze zze2) {
        ++this.zzae;
    }

    final void zzag() {
        this.zzaf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzah() {
        this.zzak();
        ((zzhf)this.zzq()).zzd();
        if (this.zzz == null || this.zzaa == 0L || this.zzz != null && !this.zzz.booleanValue() && Math.abs(this.zzo.elapsedRealtime() - this.zzaa) > 1000L) {
            this.zzaa = this.zzo.elapsedRealtime();
            zzw zzw2 = this.zzg;
            this.zzz = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() || this.zzh.zzx() || zzge.zza(this.zzb) && zzla.zza(this.zzb, false));
            if (this.zzz.booleanValue()) {
                this.zzz = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzz;
    }

    @WorkerThread
    public final void zzai() {
        ((zzhf)this.zzq()).zzd();
        zzgo.zzb(this.zzaj());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzh.zzi().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzaj().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzhf)this.zzy()).zzt().zze(), string, (String)pair.first, this.zzc().zzv.zza() - 1L);
        zzgn zzgn2 = new zzgn(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzin zzin2 = this.zzaj();
        ((zzhf)zzin2).zzd();
        zzin2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzgn2);
        ((zzhf)zzin2).zzq().zzb(new zzip(zzin2, string2, uRL2, null, null, zzgn2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzgo zzgo2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzgo2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzgo2.zzc().zzu.zza(true);
        if (byArray2.length == 0) {
            zzgo2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzgo2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzla zzla2 = zzgo2.zzi();
            ((zzhf)zzla2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzhf)zzla2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzgo2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzgo2.zzq.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzla2 = zzgo2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzla2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzhf)zzla2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzgo2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzgo zzgo2, zzhq zzhq2) {
        zzgo2.zza(zzhq2);
    }
}

