/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zzla;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zziw
extends zze {
    @VisibleForTesting
    protected zzit zza;
    private volatile zzit zzb;
    private zzit zzc;
    private final Map<Activity, zzit> zzd = new ConcurrentHashMap<Activity, zzit>();
    private zzit zze;
    private String zzf;

    public zziw(zzgo zzgo2) {
        super(zzgo2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzit zzab() {
        this.zzw();
        ((zzhf)this).zzd();
        return this.zza;
    }

    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzb == null) {
            ((zzhf)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzhf)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zziw.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzla.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzhf)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzhf)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzhf)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzhf)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzit zzit2 = new zzit(string, string2, ((zzhf)this).zzp().zzg());
        this.zzd.put(activity, zzit2);
        this.zza(activity, zzit2, true);
    }

    public final zzit zzac() {
        ((zzhf)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzit zzit2, boolean bl) {
        zzit zzit3;
        zzit zzit4 = zzit3 = this.zzb == null ? this.zzc : this.zzb;
        if (zzit2.zzb == null) {
            zzit2 = new zzit(zzit2.zza, zziw.zza(activity.getClass().getCanonicalName()), zzit2.zzc);
        }
        zzit zzit5 = zzit2;
        this.zzc = this.zzb;
        this.zzb = zzit5;
        long l = ((zzhf)this).zzm().elapsedRealtime();
        ((zzhf)this).zzq().zza(new zziv(this, bl, l, zzit3, zzit5));
    }

    @WorkerThread
    private final void zza(@NonNull zzit zzit2, boolean bl, long l) {
        ((zzf)this).zze().zza(((zzhf)this).zzm().elapsedRealtime());
        if (((zzf)this).zzk().zza(zzit2.zzd, bl, l)) {
            zzit2.zzd = false;
        }
    }

    public static void zza(zzit zzit2, Bundle bundle, boolean bl) {
        if (bundle != null && zzit2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzit2.zza != null) {
                bundle.putString("_sn", zzit2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzit2.zzb);
            bundle.putLong("_si", zzit2.zzc);
            return;
        }
        if (bundle != null && zzit2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzit zzit2) {
        ((zzhf)this).zzd();
        zziw zziw2 = this;
        synchronized (zziw2) {
            if (this.zzf == null || this.zzf.equals(string) || zzit2 != null) {
                this.zzf = string;
                this.zze = zzit2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzit zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzit zzit2 = this.zzd.get(activity);
        if (zzit2 == null) {
            String string = zziw.zza(activity.getClass().getCanonicalName());
            zzit2 = new zzit(null, string, ((zzhf)this).zzp().zzg());
            this.zzd.put(activity, zzit2);
        }
        return zzit2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzit zzit2 = new zzit(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzit2);
    }

    @MainThread
    public final void zza(Activity activity) {
        zzit zzit2 = this.zzd(activity);
        this.zza(activity, zzit2, false);
        zzb zzb2 = ((zzf)this).zze();
        long l = ((zzhf)zzb2).zzm().elapsedRealtime();
        ((zzhf)zzb2).zzq().zza(new zzc(zzb2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        zzit zzit2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        long l = ((zzhf)this).zzm().elapsedRealtime();
        ((zzhf)this).zzq().zza(new zziy(this, zzit2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzit zzit2 = this.zzd.get(activity);
        if (zzit2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzit2.zzc);
        bundle2.putString("name", zzit2.zza);
        bundle2.putString("referrer_name", zzit2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zziw zziw2, zzit zzit2, boolean bl, long l) {
        zziw2.zza(zzit2, bl, l);
    }
}

