/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzix
extends zze {
    private final zzjp zza;
    private zzfc zzb;
    private volatile Boolean zzc;
    private final zzaf zzd;
    private final zzkl zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzaf zzg;

    protected zzix(zzgo zzgo2) {
        super(zzgo2);
        this.zze = new zzkl(zzgo2.zzm());
        this.zza = new zzjp(this);
        this.zzd = new zzja(this, zzgo2);
        this.zzg = new zzjh(this, zzgo2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final boolean zzab() {
        ((zzhf)this).zzd();
        this.zzw();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzac() {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(true);
        this.zza(new zzjk(this, zzm2));
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzfc zzfc2, AbstractSafeParcelable abstractSafeParcelable, zzm zzm2) {
        ((zzhf)this).zzd();
        ((zzhf)this).zzb();
        this.zzw();
        boolean bl = this.zzai();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            List<AbstractSafeParcelable> list;
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            if (bl && (list = ((zzf)this).zzj().zza(100)) != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzan) {
                    try {
                        zzfc2.zza((zzan)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhf)this).zzr().zzf().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkz) {
                    try {
                        zzfc2.zza((zzkz)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhf)this).zzr().zzf().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzv) {
                    try {
                        zzfc2.zza((zzv)abstractSafeParcelable2, zzm2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzhf)this).zzr().zzf().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzhf)this).zzr().zzf().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzan zzan2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzan2));
        ((zzhf)this).zzd();
        this.zzw();
        boolean bl = this.zzai();
        boolean bl2 = bl && ((zzf)this).zzj().zza(zzan2);
        zzm zzm2 = this.zza(true);
        this.zza(new zzjj(this, bl, bl2, zzan2, zzm2, string));
    }

    @WorkerThread
    protected final void zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)((Object)zzv2));
        ((zzhf)this).zzd();
        this.zzw();
        zzw zzw2 = ((zzhf)this).zzu();
        boolean bl = true;
        boolean bl2 = true && ((zzf)this).zzj().zza(zzv2);
        zzv zzv3 = new zzv(zzv2);
        zzm zzm2 = this.zza(true);
        this.zza(new zzjm(this, bl, bl2, zzv3, zzm2, zzv2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzv>> atomicReference, String string, String string2, String string3) {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjl(this, atomicReference, string, string2, string3, zzm2));
    }

    @WorkerThread
    protected final void zza(zzn zzn2, String string, String string2) {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjo(this, string, string2, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkz>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjn(this, atomicReference, string, string2, string3, bl, zzm2));
    }

    @WorkerThread
    protected final void zza(zzn zzn2, String string, String string2, boolean bl) {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjq(this, string, string2, bl, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zza(zzkz zzkz2) {
        ((zzhf)this).zzd();
        this.zzw();
        boolean bl = this.zzai() && ((zzf)this).zzj().zza(zzkz2);
        zzm zzm2 = this.zza(true);
        this.zza(new zziz(this, bl, zzkz2, zzm2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkz>> atomicReference, boolean bl) {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjc(this, atomicReference, zzm2, bl));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzhf)this).zzd();
        ((zzhf)this).zzb();
        this.zzw();
        zzm zzm2 = this.zza(false);
        if (this.zzai()) {
            ((zzf)this).zzj().zzab();
        }
        this.zza(new zzjb(this, zzm2));
    }

    private final boolean zzai() {
        zzw zzw2 = ((zzhf)this).zzu();
        return true;
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzje(this, atomicReference, zzm2));
    }

    @WorkerThread
    public final void zza(zzn zzn2) {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(false);
        this.zza(new zzjd(this, zzm2, zzn2));
    }

    @WorkerThread
    protected final void zzae() {
        ((zzhf)this).zzd();
        this.zzw();
        zzm zzm2 = this.zza(true);
        boolean bl = ((zzhf)this).zzt().zza(zzap.zzbz);
        if (bl) {
            ((zzf)this).zzj().zzac();
        }
        this.zza(new zzjg(this, zzm2, bl));
    }

    @WorkerThread
    protected final void zza(zzit zzit2) {
        ((zzhf)this).zzd();
        this.zzw();
        this.zza(new zzjf(this, zzit2));
    }

    @WorkerThread
    private final void zzaj() {
        ((zzhf)this).zzd();
        this.zze.zza();
        this.zzd.zza((Long)zzap.zzah.zza(null));
    }

    @WorkerThread
    final void zzaf() {
        zzw zzw2;
        Boolean bl;
        zzix zzix2;
        ((zzhf)this).zzd();
        this.zzw();
        if (this.zzab()) {
            return;
        }
        if (this.zzc == null) {
            boolean bl2;
            zzix2 = this;
            ((zzhf)zzix2).zzd();
            zzix2.zzw();
            bl = ((zzhf)zzix2).zzs().zzj();
            if (bl != null && bl.booleanValue()) {
                bl2 = true;
            } else {
                boolean bl3;
                boolean bl4;
                zzw2 = ((zzhf)zzix2).zzu();
                if (((zzf)zzix2).zzg().zzag() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzhf)zzix2).zzr().zzx().zza("Checking service availability");
                    int n = ((zzhf)zzix2).zzp().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzhf)zzix2).zzr().zzx().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzhf)zzix2).zzr().zzx().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzhf)zzix2).zzr().zzi().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzhf)zzix2).zzr().zzw().zza("Service container out of date");
                            if (((zzhf)zzix2).zzp().zzj() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            Boolean bl5 = ((zzhf)zzix2).zzs().zzj();
                            bl4 = bl5 == null || bl5 != false;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzhf)zzix2).zzr().zzi().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzhf)zzix2).zzr().zzi().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzhf)zzix2).zzr().zzi().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzhf)zzix2).zzt().zzx()) {
                    ((zzhf)zzix2).zzr().zzf().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzhf)zzix2).zzs().zza(bl4);
                }
                bl2 = bl4;
            }
            this.zzc = bl2;
        }
        if (this.zzc.booleanValue()) {
            this.zza.zzb();
            return;
        }
        if (!((zzhf)this).zzt().zzx()) {
            Intent intent;
            zzix2 = this;
            zzw2 = ((zzhf)zzix2).zzu();
            bl = ((zzhf)zzix2).zzn().getPackageManager();
            List list = bl.queryIntentServices(intent = new Intent().setClassName(((zzhf)zzix2).zzn(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                zzw2 = ((zzhf)this).zzu();
                intent2.setComponent(new ComponentName(((zzhf)this).zzn(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzhf)this).zzr().zzf().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzag() {
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzfc zzfc2) {
        ((zzhf)this).zzd();
        Preconditions.checkNotNull((Object)zzfc2);
        this.zzb = zzfc2;
        this.zzaj();
        this.zzal();
    }

    @WorkerThread
    public final void zzah() {
        ((zzhf)this).zzd();
        this.zzw();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzhf)this).zzn(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzhf)this).zzd();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzhf)this).zzr().zzx().zza("Disconnected from device MeasurementService", componentName);
            zzix zzix2 = this;
            ((zzhf)zzix2).zzd();
            zzix2.zzaf();
        }
    }

    @WorkerThread
    private final void zzak() {
        ((zzhf)this).zzd();
        if (!this.zzab()) {
            return;
        }
        ((zzhf)this).zzr().zzx().zza("Inactivity, disconnecting from the service");
        this.zzah();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzhf)this).zzd();
        if (this.zzab()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzhf)this).zzr().zzf().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzaf();
    }

    @WorkerThread
    private final void zzal() {
        ((zzhf)this).zzd();
        ((zzhf)this).zzr().zzx().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzhf)this).zzr().zzf().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzm zza(boolean bl) {
        zzw zzw2 = ((zzhf)this).zzu();
        return ((zzf)this).zzg().zza(bl ? ((zzhf)this).zzr().zzy() : null);
    }

    @WorkerThread
    public final void zza(zzn zzn2, zzan zzan2, String string) {
        ((zzhf)this).zzd();
        this.zzw();
        int n = ((zzhf)this).zzp().zza(12451000);
        if (n != 0) {
            ((zzhf)this).zzr().zzi().zza("Not bundling data. Service unavailable or out of date");
            ((zzhf)this).zzp().zza(zzn2, new byte[0]);
            return;
        }
        this.zza(new zzji(this, zzan2, string, zzn2));
    }

    static /* synthetic */ zzjp zza(zzix zzix2) {
        return zzix2.zza;
    }

    static /* synthetic */ void zza(zzix zzix2, ComponentName componentName) {
        zzix2.zza(componentName);
    }

    static /* synthetic */ zzfc zza(zzix zzix2, zzfc zzfc2) {
        zzix2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzix zzix2) {
        zzix2.zzal();
    }

    static /* synthetic */ void zzc(zzix zzix2) {
        zzix2.zzak();
    }

    static /* synthetic */ zzfc zzd(zzix zzix2) {
        return zzix2.zzb;
    }

    static /* synthetic */ void zze(zzix zzix2) {
        zzix2.zzaj();
    }
}

