/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.zza;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
@KeepForSdk
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile AppMeasurement zza;
    private final zzgq zzb;
    private final zziq zzc;
    private final boolean zzd;

    @Deprecated
    @ShowFirstParty
    @Keep
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurement getInstance(Context context) {
        return AppMeasurement.zza(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    private static AppMeasurement zza(Context context, String string, String string2) {
        if (zza != null) return zza;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zza != null) return zza;
            zziq zziq2 = AppMeasurement.zzb(context, null);
            if (zziq2 != null) {
                zza = new AppMeasurement(zziq2);
            } else {
                zzgq zzgq2 = zzgq.zza(context, null, null, null);
                zza = new AppMeasurement(zzgq2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zza;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppMeasurement zza(Context context, Bundle bundle) {
        if (zza != null) return zza;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zza != null) return zza;
            zziq zziq2 = AppMeasurement.zzb(context, bundle);
            if (zziq2 != null) {
                zza = new AppMeasurement(zziq2);
            } else {
                zzgq zzgq2 = zzgq.zza(context, null, null, bundle);
                zza = new AppMeasurement(zzgq2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zza;
        }
    }

    private static zziq zzb(Context context, Bundle bundle) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return (zziq)clazz.getDeclaredMethod("getScionFrontendApiImplementation", Context.class, Bundle.class).invoke(null, context, bundle);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        if (this.zzd) {
            this.zzc.zza(bl);
            return;
        }
        this.zzb.zzh().zza(bl);
    }

    public final void zza(boolean bl) {
        if (this.zzd) {
            this.zzc.zzb(bl);
            return;
        }
        this.zzb.zzh().zzb(bl);
    }

    private AppMeasurement(zzgq zzgq2) {
        Preconditions.checkNotNull((Object)zzgq2);
        this.zzb = zzgq2;
        this.zzc = null;
        this.zzd = false;
    }

    private AppMeasurement(zziq zziq2) {
        Preconditions.checkNotNull((Object)zziq2);
        this.zzc = zziq2;
        this.zzb = null;
        this.zzd = true;
    }

    @ShowFirstParty
    @Keep
    public void logEventInternal(String string, String string2, Bundle bundle) {
        if (this.zzd) {
            this.zzc.zza(string, string2, bundle);
            return;
        }
        this.zzb.zzh().zza(string, string2, bundle);
    }

    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        if (this.zzd) {
            this.zzc.zza(string, string2, bundle, l);
            return;
        }
        Bundle bundle2 = bundle;
        String string3 = string2;
        String string4 = string;
        this.zzb.zzh().zza(string4, string3, bundle2, true, false, l);
    }

    @ShowFirstParty
    @KeepForSdk
    public void setUserPropertyInternal(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzd) {
            this.zzc.zza(string, string2, object);
            return;
        }
        this.zzb.zzh().zza(string, string2, object, true);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        if (this.zzd) {
            return this.zzc.zza((String)null, (String)null, bl);
        }
        List<zzkz> list = this.zzb.zzh().zzc(bl);
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzkz zzkz2 : list) {
            arrayMap.put(zzkz2.zza, zzkz2.zza());
        }
        return arrayMap;
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        if (this.zzd) {
            this.zzc.zza(eventInterceptor);
            return;
        }
        this.zzb.zzh().zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzd) {
            this.zzc.zza(onEventListener);
            return;
        }
        this.zzb.zzh().zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzd) {
            this.zzc.zzb(onEventListener);
            return;
        }
        this.zzb.zzh().zzb(onEventListener);
    }

    @Nullable
    @Keep
    public String getCurrentScreenName() {
        if (this.zzd) {
            return this.zzc.zza();
        }
        return this.zzb.zzh().zzaj();
    }

    @Nullable
    @Keep
    public String getCurrentScreenClass() {
        if (this.zzd) {
            return this.zzc.zzb();
        }
        return this.zzb.zzh().zzak();
    }

    @Nullable
    @Keep
    public String getAppInstanceId() {
        if (this.zzd) {
            return this.zzc.zzc();
        }
        return this.zzb.zzh().zzah();
    }

    @Nullable
    @Keep
    public String getGmpAppId() {
        if (this.zzd) {
            return this.zzc.zzd();
        }
        return this.zzb.zzh().zzal();
    }

    @Keep
    public long generateEventId() {
        if (this.zzd) {
            return this.zzc.zze();
        }
        return this.zzb.zzi().zzg();
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzd) {
            this.zzc.zza(string);
            return;
        }
        this.zzb.zzz().zza(string, this.zzb.zzm().elapsedRealtime());
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzd) {
            this.zzc.zzb(string);
            return;
        }
        this.zzb.zzz().zzb(string, this.zzb.zzm().elapsedRealtime());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        if (this.zzd) {
            this.zzc.zza(conditionalUserProperty.zza());
            return;
        }
        this.zzb.zzh().zza(conditionalUserProperty.zza());
    }

    @Keep
    @VisibleForTesting
    protected void setConditionalUserPropertyAs(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        if (this.zzd) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        this.zzb.zzh().zzb(conditionalUserProperty.zza());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (this.zzd) {
            this.zzc.zzb(string, string2, bundle);
            return;
        }
        this.zzb.zzh().zzc(string, string2, bundle);
    }

    @Keep
    @VisibleForTesting
    protected void clearConditionalUserPropertyAs(@NonNull @Size(min=1L) String string, @NonNull @Size(min=1L, max=24L) String string2, @Nullable String string3, @Nullable Bundle bundle) {
        if (this.zzd) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        this.zzb.zzh().zza(string, string2, string3, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        if (this.zzd) {
            return this.zzc.zza(string, string2, bl);
        }
        return this.zzb.zzh().zza(string, string2, bl);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3, boolean bl) {
        if (this.zzd) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        return this.zzb.zzh().zza(string, string2, string3, bl);
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        List<Bundle> list = this.zzd ? this.zzc.zza(string, string2) : this.zzb.zzh().zza(string, string2);
        ArrayList<ConditionalUserProperty> arrayList = new ArrayList<ConditionalUserProperty>(list == null ? 0 : list.size());
        for (Bundle bundle : list) {
            arrayList.add(new ConditionalUserProperty(bundle, null));
        }
        return arrayList;
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected List<ConditionalUserProperty> getConditionalUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3) {
        if (this.zzd) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        ArrayList<Bundle> arrayList = this.zzb.zzh().zza(string, string2, string3);
        ArrayList<ConditionalUserProperty> arrayList2 = new ArrayList<ConditionalUserProperty>(arrayList == null ? 0 : arrayList.size());
        ArrayList<Bundle> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Bundle bundle = arrayList3.get(i);
            Bundle bundle2 = bundle;
            arrayList2.add(new ConditionalUserProperty(bundle2, null));
        }
        return arrayList2;
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        if (this.zzd) {
            return this.zzc.zzc(string);
        }
        this.zzb.zzh();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        return 25;
    }

    @KeepForSdk
    public Boolean getBoolean() {
        if (this.zzd) {
            return (Boolean)this.zzc.zza(4);
        }
        return this.zzb.zzh().zzac();
    }

    @KeepForSdk
    public String getString() {
        if (this.zzd) {
            return (String)this.zzc.zza(0);
        }
        return this.zzb.zzh().zzad();
    }

    @KeepForSdk
    public Long getLong() {
        if (this.zzd) {
            return (Long)this.zzc.zza(1);
        }
        return this.zzb.zzh().zzae();
    }

    @KeepForSdk
    public Integer getInteger() {
        if (this.zzd) {
            return (Integer)this.zzc.zza(3);
        }
        return this.zzb.zzh().zzaf();
    }

    @KeepForSdk
    public Double getDouble() {
        if (this.zzd) {
            return (Double)this.zzc.zza(2);
        }
        return this.zzb.zzh().zzag();
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        public String mTimedOutEventName;
        @Keep
        public Bundle mTimedOutEventParams;
        @Keep
        public String mTriggeredEventName;
        @Keep
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        public String mExpiredEventName;
        @Keep
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @KeepForSdk
        public ConditionalUserProperty(ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zziw.zza((Object)conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }

        private ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzhm.zza((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzhm.zza((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzhm.zza((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzhm.zza((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzhm.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            this.mTriggerTimeout = (Long)zzhm.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)0L);
            this.mTimedOutEventName = (String)zzhm.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzhm.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzhm.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzhm.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzhm.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)0L);
            this.mExpiredEventName = (String)zzhm.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzhm.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        }

        private final Bundle zza() {
            Bundle bundle = new Bundle();
            if (this.mAppId != null) {
                bundle.putString("app_id", this.mAppId);
            }
            if (this.mOrigin != null) {
                bundle.putString("origin", this.mOrigin);
            }
            if (this.mName != null) {
                bundle.putString("name", this.mName);
            }
            if (this.mValue != null) {
                zzhm.zza((Bundle)bundle, (Object)this.mValue);
            }
            if (this.mTriggerEventName != null) {
                bundle.putString("trigger_event_name", this.mTriggerEventName);
            }
            bundle.putLong("trigger_timeout", this.mTriggerTimeout);
            if (this.mTimedOutEventName != null) {
                bundle.putString("timed_out_event_name", this.mTimedOutEventName);
            }
            if (this.mTimedOutEventParams != null) {
                bundle.putBundle("timed_out_event_params", this.mTimedOutEventParams);
            }
            if (this.mTriggeredEventName != null) {
                bundle.putString("triggered_event_name", this.mTriggeredEventName);
            }
            if (this.mTriggeredEventParams != null) {
                bundle.putBundle("triggered_event_params", this.mTriggeredEventParams);
            }
            bundle.putLong("time_to_live", this.mTimeToLive);
            if (this.mExpiredEventName != null) {
                bundle.putString("expired_event_name", this.mExpiredEventName);
            }
            if (this.mExpiredEventParams != null) {
                bundle.putBundle("expired_event_params", this.mExpiredEventParams);
            }
            bundle.putLong("creation_timestamp", this.mCreationTimestamp);
            bundle.putBoolean("active", this.mActive);
            bundle.putLong("triggered_timestamp", this.mTriggeredTimestamp);
            return bundle;
        }

        /* synthetic */ ConditionalUserProperty(Bundle bundle, zza zza2) {
            this(bundle);
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzhp {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzhq {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class UserProperty
    extends zzhn {
        @ShowFirstParty
        @KeepForSdk
        public static final String FIREBASE_LAST_NOTIFICATION = "_ln";

        private UserProperty() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Param
    extends zzho {
        @ShowFirstParty
        @KeepForSdk
        public static final String FATAL = "fatal";
        @ShowFirstParty
        @KeepForSdk
        public static final String TIMESTAMP = "timestamp";
        @ShowFirstParty
        @KeepForSdk
        public static final String TYPE = "type";

        private Param() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Event
    extends zzhl {
        @ShowFirstParty
        @KeepForSdk
        public static final String APP_EXCEPTION = "_ae";
        @ShowFirstParty
        @KeepForSdk
        public static final String AD_REWARD = "_ar";

        private Event() {
        }
    }
}

