/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhk;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgj
extends zzhk {
    private zzgn zza;
    private zzgn zzb;
    private final PriorityBlockingQueue<zzgo<?>> zzc;
    private final BlockingQueue<zzgo<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzgj(zzgq zzgq2) {
        super(zzgq2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzgl(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzgl(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgo zzgo2 = new zzgo(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzhh)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzgo2.run();
        } else {
            this.zza(zzgo2);
        }
        return zzgo2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzgo zzgo2 = new zzgo(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzgo2.run();
        } else {
            this.zza(zzgo2);
        }
        return zzgo2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzgo(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzhh)this).zzq().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzhh)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzhh)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzgo<?> zzgo2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzgo2);
            if (this.zza == null) {
                this.zza = new zzgn(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzgo zzgo2 = new zzgo(this, runnable, false, "Task exception on network thread");
        zzgj zzgj2 = this;
        Object object = zzgj2.zzg;
        synchronized (object) {
            zzgj2.zzd.add(zzgo2);
            if (zzgj2.zzb == null) {
                zzgj2.zzb = new zzgn(zzgj2, "Measurement Network", zzgj2.zzd);
                zzgj2.zzb.setUncaughtExceptionHandler(zzgj2.zzf);
                zzgj2.zzb.start();
            } else {
                zzgj2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzgj zzgj2) {
        return zzgj2.zzh;
    }

    static /* synthetic */ boolean zzb(zzgj zzgj2) {
        return zzgj2.zzi;
    }

    static /* synthetic */ Object zzc(zzgj zzgj2) {
        return zzgj2.zzg;
    }

    static /* synthetic */ zzgn zzd(zzgj zzgj2) {
        return zzgj2.zza;
    }

    static /* synthetic */ zzgn zza(zzgj zzgj2, zzgn zzgn2) {
        zzgj2.zza = null;
        return null;
    }

    static /* synthetic */ zzgn zze(zzgj zzgj2) {
        return zzgj2.zzb;
    }

    static /* synthetic */ zzgn zzb(zzgj zzgj2, zzgn zzgn2) {
        zzgj2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

