/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzky;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzgq
implements zzhj {
    private static volatile zzgq zza;
    private final Context zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final boolean zzf;
    private final zzw zzg;
    private final zzx zzh;
    private final zzfv zzi;
    private final zzfj zzj;
    private final zzgj zzk;
    private final zzke zzl;
    private final zzla zzm;
    private final zzfh zzn;
    private final Clock zzo;
    private final zziy zzp;
    private final zzhr zzq;
    private final zzb zzr;
    private final zzip zzs;
    private zzff zzt;
    private zziz zzu;
    private zzah zzv;
    private zzfg zzw;
    private zzgb zzx;
    private boolean zzy = false;
    private Boolean zzz;
    private long zzaa;
    private volatile Boolean zzab;
    @VisibleForTesting
    private Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    private int zzae;
    private AtomicInteger zzaf = new AtomicInteger(0);
    private final long zzag;

    private zzgq(zzhs zzhs2) {
        Object object;
        Preconditions.checkNotNull((Object)zzhs2);
        Object object2 = zzhs2.zza;
        zzez.zza = this.zzg = new zzw((Context)object2);
        this.zzb = zzhs2.zza;
        this.zzc = zzhs2.zzb;
        this.zzd = zzhs2.zzc;
        this.zze = zzhs2.zzd;
        this.zzf = zzhs2.zzh;
        this.zzab = zzhs2.zze;
        zzv zzv2 = zzhs2.zzg;
        if (zzv2 != null && zzv2.zzg != null) {
            object = zzv2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzac = (Boolean)object;
            }
            if ((object = zzv2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
        }
        zzcl.zza(this.zzb);
        this.zzo = DefaultClock.getInstance();
        this.zzag = this.zzo.currentTimeMillis();
        object2 = this;
        this.zzh = new zzx((zzgq)object2);
        object2 = this;
        object = new zzfv((zzgq)object2);
        ((zzhk)object).zzab();
        this.zzi = object;
        object2 = this;
        zzfj zzfj2 = new zzfj((zzgq)object2);
        zzfj2.zzab();
        this.zzj = zzfj2;
        object2 = this;
        zzla zzla2 = new zzla((zzgq)object2);
        zzla2.zzab();
        this.zzm = zzla2;
        object2 = this;
        zzfh zzfh2 = new zzfh((zzgq)object2);
        zzfh2.zzab();
        this.zzn = zzfh2;
        object2 = this;
        this.zzr = new zzb((zzgq)object2);
        object2 = this;
        zziy zziy2 = new zziy((zzgq)object2);
        zziy2.zzx();
        this.zzp = zziy2;
        object2 = this;
        zzhr zzhr2 = new zzhr((zzgq)object2);
        zzhr2.zzx();
        this.zzq = zzhr2;
        object2 = this;
        zzke zzke2 = new zzke((zzgq)object2);
        zzke2.zzx();
        this.zzl = zzke2;
        object2 = this;
        zzip zzip2 = new zzip((zzgq)object2);
        zzip2.zzab();
        this.zzs = zzip2;
        object2 = this;
        zzgj zzgj2 = new zzgj((zzgq)object2);
        zzgj2.zzab();
        this.zzk = zzgj2;
        boolean bl = zzhs2.zzg != null && zzhs2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzw zzw2 = ((zzgq)object2).zzg;
        if (((zzgq)object2).zzb.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhr zzhr3 = ((zzgq)object2).zzh();
            if (((zzhh)zzhr3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzhh)zzhr3).zzn().getApplicationContext();
                if (zzhr3.zza == null) {
                    zzhr3.zza = new zzio(zzhr3, null);
                }
                if (bl3) {
                    zzio zzio2 = zzhr3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzio2);
                    zzio2 = zzhr3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzio2);
                    ((zzhh)zzhr3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzgq)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzk.zza(new zzgs(this, zzhs2));
    }

    @WorkerThread
    private final void zza(zzhs zzhs2) {
        ((zzhh)this.zzq()).zzd();
        Object object = this;
        zzah zzah2 = new zzah((zzgq)object);
        zzah2.zzab();
        this.zzv = zzah2;
        zzgq zzgq2 = this;
        object = zzhs2;
        zzfg zzfg2 = new zzfg(zzgq2, ((zzhs)object).zzf);
        zzfg2.zzx();
        this.zzw = zzfg2;
        object = this;
        zzff zzff2 = new zzff((zzgq)object);
        zzff2.zzx();
        this.zzt = zzff2;
        object = this;
        zziz zziz2 = new zziz((zzgq)object);
        zziz2.zzx();
        this.zzu = zziz2;
        this.zzm.zzac();
        this.zzi.zzac();
        object = this;
        this.zzx = new zzgb((zzgq)object);
        this.zzw.zzy();
        this.zzr().zzv().zza("App measurement initialized, version", this.zzh.zzf());
        zzw zzw2 = this.zzg;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzw2 = this.zzg;
        String string = zzfg2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            String string2;
            zzfl zzfl2;
            if (this.zzi().zzf(string)) {
                zzfl2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzfl2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzfl2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzae != this.zzaf.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzae, this.zzaf.get());
        }
        this.zzy = true;
    }

    @WorkerThread
    protected final void zza() {
        ((zzhh)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzo.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zzag);
            this.zzc().zzh.zza(this.zzag);
        }
        if (!this.zzah()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzw zzw2 = this.zzg;
                if (!Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() && !this.zzh.zzy()) {
                    if (!zzgg.zza(this.zzb)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzla.zza(this.zzb, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzw zzw3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzla.zza(this.zzy().zzac(), this.zzc().zzh(), this.zzy().zzad(), this.zzc().zzi())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzk();
                    this.zzk().zzab();
                    this.zzu.zzah();
                    this.zzu.zzaf();
                    this.zzc().zzh.zza(this.zzag);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzw3 = this.zzg;
            if (zzkb.zzb() && this.zzh.zza(zzap.zzcq) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzw.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzw.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzh.zzh()) {
                    this.zzc().zzc(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zze().zza.zza();
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzh.zza(zzap.zzbi));
        this.zzc().zzp.zza(this.zzh.zza(zzap.zzbj));
    }

    @Override
    public final zzw zzu() {
        return this.zzg;
    }

    public final zzx zzb() {
        return this.zzh;
    }

    public final zzfv zzc() {
        zzgq.zza(this.zzi);
        return this.zzi;
    }

    @Override
    public final zzfj zzr() {
        zzgq.zzb(this.zzj);
        return this.zzj;
    }

    public final zzfj zzd() {
        if (this.zzj != null && this.zzj.zzz()) {
            return this.zzj;
        }
        return null;
    }

    @Override
    public final zzgj zzq() {
        zzgq.zzb(this.zzk);
        return this.zzk;
    }

    public final zzke zze() {
        zzgq.zzb(this.zzl);
        return this.zzl;
    }

    public final zzgb zzf() {
        return this.zzx;
    }

    final zzgj zzg() {
        return this.zzk;
    }

    public final zzhr zzh() {
        zzgq.zzb(this.zzq);
        return this.zzq;
    }

    public final zzla zzi() {
        zzgq.zza(this.zzm);
        return this.zzm;
    }

    public final zzfh zzj() {
        zzgq.zza(this.zzn);
        return this.zzn;
    }

    public final zzff zzk() {
        zzgq.zzb(this.zzt);
        return this.zzt;
    }

    private final zzip zzaj() {
        zzgq.zzb(this.zzs);
        return this.zzs;
    }

    @Override
    public final Context zzn() {
        return this.zzb;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final String zzo() {
        return this.zzc;
    }

    public final String zzp() {
        return this.zzd;
    }

    public final String zzs() {
        return this.zze;
    }

    public final boolean zzt() {
        return this.zzf;
    }

    @Override
    public final Clock zzm() {
        return this.zzo;
    }

    public final zziy zzv() {
        zzgq.zzb(this.zzp);
        return this.zzp;
    }

    public final zziz zzw() {
        zzgq.zzb(this.zzu);
        return this.zzu;
    }

    public final zzah zzx() {
        zzgq.zzb(this.zzv);
        return this.zzv;
    }

    public final zzfg zzy() {
        zzgq.zzb(this.zzw);
        return this.zzw;
    }

    public final zzb zzz() {
        if (this.zzr == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzr;
    }

    @VisibleForTesting
    public static zzgq zza(Context context, String string, String string2, Bundle bundle) {
        return zzgq.zza(context, new zzv(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgq zza(Context context, zzv zzv2) {
        if (zzv2 != null && (zzv2.zze == null || zzv2.zzf == null)) {
            zzv2 = new zzv(zzv2.zza, zzv2.zzb, zzv2.zzc, zzv2.zzd, null, null, zzv2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza == null) {
            Class<zzgq> clazz = zzgq.class;
            synchronized (zzgq.class) {
                if (zza == null) {
                    zzhs zzhs2 = new zzhs(context, zzv2);
                    zza = new zzgq(zzhs2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzv2 != null && zzv2.zzg != null && zzv2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zza.zza(zzv2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zza;
    }

    private final void zzak() {
        if (!this.zzy) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zzb(zzhk zzhk2) {
        if (zzhk2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzhk2.zzz()) {
            String string = String.valueOf(zzhk2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzv()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzhh zzhh2) {
        if (zzhh2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzab = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab != null && this.zzab != false;
    }

    @WorkerThread
    public final boolean zzab() {
        if (zzky.zzb() && this.zzh.zza(zzap.zzcx)) {
            return this.zzac() == 0;
        }
        zzgq zzgq2 = this;
        ((zzhh)zzgq2.zzq()).zzd();
        zzgq2.zzak();
        if (zzgq2.zzh.zzh()) {
            return false;
        }
        if (zzgq2.zzad != null && zzgq2.zzad.booleanValue()) {
            return false;
        }
        Boolean bl = zzgq2.zzc().zzv();
        if (bl != null) {
            return bl;
        }
        Boolean bl2 = zzgq2.zzh.zzi();
        if (bl2 != null) {
            return bl2;
        }
        if (zzgq2.zzac != null) {
            return zzgq2.zzac;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return false;
        }
        if (zzgq2.zzh.zza(zzap.zzba) && zzgq2.zzab != null) {
            return zzgq2.zzab;
        }
        return true;
    }

    @WorkerThread
    public final int zzac() {
        ((zzhh)this.zzq()).zzd();
        if (this.zzh.zzh()) {
            return 1;
        }
        if (this.zzad != null && this.zzad.booleanValue()) {
            return 2;
        }
        Boolean bl = this.zzc().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        Boolean bl2 = this.zzh.zzi();
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzh.zza(zzap.zzba) && this.zzab != null) {
            if (this.zzab.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    final long zzad() {
        Long l = this.zzc().zzh.zza();
        if (l == 0L) {
            return this.zzag;
        }
        return Math.min(this.zzag, l);
    }

    final void zzae() {
        zzw zzw2 = this.zzg;
    }

    final void zzaf() {
        zzw zzw2 = this.zzg;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzhk zzhk2) {
        ++this.zzae;
    }

    final void zza(zze zze2) {
        ++this.zzae;
    }

    final void zzag() {
        this.zzaf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzah() {
        this.zzak();
        ((zzhh)this.zzq()).zzd();
        if (this.zzz == null || this.zzaa == 0L || this.zzz != null && !this.zzz.booleanValue() && Math.abs(this.zzo.elapsedRealtime() - this.zzaa) > 1000L) {
            this.zzaa = this.zzo.elapsedRealtime();
            zzw zzw2 = this.zzg;
            this.zzz = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() || this.zzh.zzy() || zzgg.zza(this.zzb) && zzla.zza(this.zzb, false));
            if (this.zzz.booleanValue()) {
                this.zzz = this.zzi().zza(this.zzy().zzac(), this.zzy().zzad(), this.zzy().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzz;
    }

    @WorkerThread
    public final void zzai() {
        ((zzhh)this.zzq()).zzd();
        zzgq.zzb(this.zzaj());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzh.zzj().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzaj().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzhh)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzv.zza() - 1L);
        zzgp zzgp2 = new zzgp(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzip zzip2 = this.zzaj();
        ((zzhh)zzip2).zzd();
        zzip2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzgp2);
        ((zzhh)zzip2).zzq().zzb(new zzir(zzip2, string2, uRL2, null, null, zzgp2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzgq zzgq2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzgq2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzgq2.zzc().zzu.zza(true);
        if (byArray2.length == 0) {
            zzgq2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzgq2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzla zzla2 = zzgq2.zzi();
            ((zzhh)zzla2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzhh)zzla2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzgq2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzgq2.zzq.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzla2 = zzgq2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzla2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzhh)zzla2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzgq2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzgq zzgq2, zzhs zzhs2) {
        zzgq2.zza(zzhs2);
    }
}

