/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzla;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zziy
extends zze {
    @VisibleForTesting
    protected zziv zza;
    private volatile zziv zzb;
    private zziv zzc;
    private final Map<Activity, zziv> zzd = new ConcurrentHashMap<Activity, zziv>();
    private zziv zze;
    private String zzf;

    public zziy(zzgq zzgq2) {
        super(zzgq2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zziv zzab() {
        this.zzw();
        ((zzhh)this).zzd();
        return this.zza;
    }

    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzb == null) {
            ((zzhh)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzhh)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zziy.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzb.zzb.equals(string2);
        boolean bl2 = zzla.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzhh)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzhh)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzhh)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzhh)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zziv zziv2 = new zziv(string, string2, ((zzhh)this).zzp().zzg());
        this.zzd.put(activity, zziv2);
        this.zza(activity, zziv2, true);
    }

    public final zziv zzac() {
        ((zzhh)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zziv zziv2, boolean bl) {
        zziv zziv3;
        zziv zziv4 = zziv3 = this.zzb == null ? this.zzc : this.zzb;
        if (zziv2.zzb == null) {
            zziv2 = new zziv(zziv2.zza, zziy.zza(activity.getClass().getCanonicalName()), zziv2.zzc);
        }
        zziv zziv5 = zziv2;
        this.zzc = this.zzb;
        this.zzb = zziv5;
        long l = ((zzhh)this).zzm().elapsedRealtime();
        ((zzhh)this).zzq().zza(new zzix(this, bl, l, zziv3, zziv5));
    }

    @WorkerThread
    private final void zza(@NonNull zziv zziv2, boolean bl, long l) {
        ((zzf)this).zze().zza(((zzhh)this).zzm().elapsedRealtime());
        if (((zzf)this).zzk().zza(zziv2.zzd, bl, l)) {
            zziv2.zzd = false;
        }
    }

    public static void zza(zziv zziv2, Bundle bundle, boolean bl) {
        if (bundle != null && zziv2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zziv2.zza != null) {
                bundle.putString("_sn", zziv2.zza);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zziv2.zzb);
            bundle.putLong("_si", zziv2.zzc);
            return;
        }
        if (bundle != null && zziv2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zziv zziv2) {
        ((zzhh)this).zzd();
        zziy zziy2 = this;
        synchronized (zziy2) {
            if (this.zzf == null || this.zzf.equals(string) || zziv2 != null) {
                this.zzf = string;
                this.zze = zziv2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zziv zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zziv zziv2 = this.zzd.get(activity);
        if (zziv2 == null) {
            String string = zziy.zza(activity.getClass().getCanonicalName());
            zziv2 = new zziv(null, string, ((zzhh)this).zzp().zzg());
            this.zzd.put(activity, zziv2);
        }
        return zziv2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zziv zziv2 = new zziv(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zziv2);
    }

    @MainThread
    public final void zza(Activity activity) {
        zziv zziv2 = this.zzd(activity);
        this.zza(activity, zziv2, false);
        zzb zzb2 = ((zzf)this).zze();
        long l = ((zzhh)zzb2).zzm().elapsedRealtime();
        ((zzhh)zzb2).zzq().zza(new zzc(zzb2, l));
    }

    @MainThread
    public final void zzb(Activity activity) {
        zziv zziv2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        long l = ((zzhh)this).zzm().elapsedRealtime();
        ((zzhh)this).zzq().zza(new zzja(this, zziv2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zziv zziv2 = this.zzd.get(activity);
        if (zziv2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zziv2.zzc);
        bundle2.putString("name", zziv2.zza);
        bundle2.putString("referrer_name", zziv2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void zzc(Activity activity) {
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zziy zziy2, zziv zziv2, boolean bl, long l) {
        zziy2.zza(zziv2, bl, l);
    }
}

