/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjy;

@VisibleForTesting
public final class zzjr
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzfk zzc;
    final /* synthetic */ zziz zza;

    protected zzjr(zziz zziz2) {
        this.zza = zziz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzhh)this.zza).zzd();
        Context context = ((zzhh)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzjr zzjr2 = this;
        synchronized (zzjr2) {
            if (this.zzb) {
                ((zzhh)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzhh)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zziz.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzjr zzjr2 = this;
        synchronized (zzjr2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzhh)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzfb zzfb2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfb2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfb ? (zzfb)iInterface : new zzfd(iBinder2));
                    ((zzhh)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzhh)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzhh)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfb2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzhh)this.zza).zzn(), (ServiceConnection)zziz.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfb2;
                ((zzhh)this.zza).zzq().zza(new zzju(this, (zzfb)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzhh)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzhh)this.zza).zzq().zza(new zzjt(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzhh)this.zza).zzd();
        Context context = ((zzhh)this.zza).zzn();
        zzjr zzjr2 = this;
        synchronized (zzjr2) {
            if (this.zzb) {
                ((zzhh)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzhh)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzfk(context, Looper.getMainLooper(), this, this);
            ((zzhh)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzjr zzjr2 = this;
        synchronized (zzjr2) {
            try {
                zzfb zzfb2 = (zzfb)this.zzc.getService();
                ((zzhh)this.zza).zzq().zza(new zzjw(this, zzfb2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzhh)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzhh)this.zza).zzq().zza(new zzjv(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfj zzfj2 = this.zza.zzx.zzd();
        if (zzfj2 != null) {
            zzfj2.zzi().zza("Service connection failed", connectionResult);
        }
        zzjr zzjr2 = this;
        synchronized (zzjr2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzhh)this.zza).zzq().zza(new zzjy(this));
    }

    static /* synthetic */ boolean zza(zzjr zzjr2, boolean bl) {
        zzjr2.zzb = false;
        return false;
    }
}

